// // Usamos DOMContentLoaded + load para máxima compatibilidad
// document.addEventListener('DOMContentLoaded', () => {
//     const loader = document.getElementById('loader');
    
//     if (loader) {
//         // Forzar renderizado antes de la transición (truco de rendimiento)
//         loader.style.willChange = 'opacity';
        
//         setTimeout(() => {
//             loader.style.opacity = '0';
            
//             // Esperar a que termine la transición CSS antes de ocultar
//             setTimeout(() => {
//                 loader.style.display = 'none';
//                 loader.style.willChange = 'auto';
//             }, 2000); // Debe coincidir con el tiempo de transición CSS
//         }, 3000); // 2 segundos de delay inicial
//     } else {
//         console.warn('Loader no encontrado');
//     }
// });

window.addEventListener('load', () => {
    const loader = document.getElementById('loader');
    
    if (loader) {
      setTimeout(() => {
        // Inicia fade-out y desactiva interacciones
        loader.style.opacity = '0';
        loader.style.pointerEvents = 'none'; // ¡Esto permite clicks en los botones!
        
        // Elimina el loader del DOM después de la transición
        loader.addEventListener('transitionend', () => {
          loader.remove(); // Elimina el nodo completamente
        });
        
        // Respaldo por si transitionend no se dispara
        setTimeout(() => {
          if (document.body.contains(loader)) {
            loader.remove();
          }
        }, 1000); // 1 segundo después del fade-out
      }, 2000); // Espera 2 segundos antes de desaparecer
    }
  });



  document.addEventListener('DOMContentLoaded', function () {
    const videoModal = document.getElementById('videoModal');
    const videoContainer = document.getElementById('videoContainer');
    const videoTitle = document.getElementById('videoModalTitle');

    videoModal.addEventListener('show.bs.modal', function (event) {
        const trigger = event.relatedTarget;
        const title = trigger.getAttribute('data-title');
        let video = trigger.getAttribute('data-video');

        videoTitle.textContent = title;

        // Si el video es de YouTube, convertimos el formato
        if (video.includes('watch?v=')) {
            const videoId = video.split('watch?v=')[1];
            video = `https://www.youtube.com/embed/${videoId}?autoplay=1&mute=1`; // URL correcta
        }

        if (video.endsWith('.mp4')) {
            videoContainer.innerHTML = `
                <video class="w-100" controls autoplay muted playsinline>
                    <source src="${video}" type="video/mp4">
                    Tu navegador no soporta el video.
                </video>`;
        } else {
            videoContainer.innerHTML = `
                <iframe class="w-100 h-100" 
                        src="${video}" 
                        allow="autoplay; encrypted-media" 
                        allowfullscreen
                        frameborder="0"></iframe>`;
        }
    });

    videoModal.addEventListener('hidden.bs.modal', function () {
        videoContainer.innerHTML = ''; // Limpia el contenido
    });
});


