<?php
require '../config/config.php';
header('Content-Type: application/json');

try {
    if (!isset($_POST['usuario_id']) || !is_numeric($_POST['usuario_id'])) {
        throw new Exception("ID de usuario inválido o no recibido.");
    }

    $usuario_id = intval($_POST['usuario_id']);

    $camposPermitidos = [
        'nombre' => 'nombre_completo',
        'rfc' => 'rfc',
        'curp' => 'curp',
        'email' => 'email',
        'estado' => 'estado_lugar',
        'promotoriaID2' => 'promotoria_id',
        'puestoID2' => 'puesto_id',
        'rolID2' => 'rol_id',
        'estatus' => 'status',
        'fecha_ingreso' => 'fecha_ingreso',
        'password' => 'password'
    ];

    $camposActualizables = [];
    $valores = [];

    foreach ($camposPermitidos as $campoFormulario => $campoBD) {
        if (isset($_POST[$campoFormulario]) && trim($_POST[$campoFormulario]) !== '') {
            $valor = trim($_POST[$campoFormulario]);

            if ($campoFormulario === 'email') {
                if (!filter_var($valor, FILTER_VALIDATE_EMAIL)) {
                    throw new Exception("El correo electrónico no es válido.");
                }
            }

            if ($campoFormulario === 'rfc') {
                $valor = strtoupper($valor);
                if (!preg_match('/^[A-ZÑ&]{3,4}\d{6}[A-Z0-9]{3}$/', $valor)) {
                    throw new Exception("El RFC no tiene un formato válido.");
                }
            }

            if ($campoFormulario === 'curp') {
                $valor = strtoupper($valor);
                if (!preg_match('/^[A-Z]{4}\d{6}[HM][A-Z]{5}[A-Z0-9]\d$/', $valor)) {
                    throw new Exception("La CURP no tiene un formato válido.");
                }
            }

            if ($campoFormulario === 'fecha_ingreso') {
                if (!DateTime::createFromFormat('Y-m-d', $valor)) {
                    throw new Exception("La fecha de ingreso no es válida.");
                }
            }

            if ($campoFormulario === 'password') {
                $valor = password_hash($valor, PASSWORD_DEFAULT);
            }

            $camposActualizables[] = "$campoBD = ?";
            $valores[] = $valor;
        }
    }
    

    if (empty($camposActualizables)) {
        throw new Exception("No se recibieron campos para actualizar.");
    }

    // Verificar duplicados
    if (isset($_POST['email']) || isset($_POST['rfc']) || isset($_POST['curp'])) {
        $condiciones = [];
        $valoresCheck = [];
        $tiposCheck = '';

        if (isset($_POST['email'])) {
            $condiciones[] = 'email = ?';
            $valoresCheck[] = trim($_POST['email']);
            $tiposCheck .= 's';
        }

        if (isset($_POST['rfc'])) {
            $condiciones[] = 'rfc = ?';
            $valoresCheck[] = strtoupper(trim($_POST['rfc']));
            $tiposCheck .= 's';
        }

        if (isset($_POST['curp'])) {
            $condiciones[] = 'curp = ?';
            $valoresCheck[] = strtoupper(trim($_POST['curp']));
            $tiposCheck .= 's';
        }

        $sqlCheck = "SELECT COUNT(*) FROM usuarios WHERE (" . implode(" OR ", $condiciones) . ") AND usuario_id != ?";
        $valoresCheck[] = $usuario_id;
        $tiposCheck .= 'i';

        $stmtCheck = $conexion->prepare($sqlCheck);
        $stmtCheck->bind_param($tiposCheck, ...$valoresCheck);
        $stmtCheck->execute();
        $stmtCheck->bind_result($repetido);
        $stmtCheck->fetch();
        $stmtCheck->close();

        if ($repetido > 0) {
            http_response_code(400);
            echo json_encode(['success' => false, 'message' => 'Ya existe otro usuario con el mismo RFC, CURP o Correo.']);
            return;
        }
    }

    // Armar y ejecutar la actualización
    $sql = "UPDATE usuarios SET " . implode(', ', $camposActualizables) . " WHERE usuario_id = ?";
    $valores[] = $usuario_id;
    $tipos = str_repeat('s', count($valores) - 1) . 'i';

    $stmt = $conexion->prepare($sql);
    $stmt->bind_param($tipos, ...$valores);

    if ($stmt->execute()) {
        if ($stmt->affected_rows === 0) {
            echo json_encode(['success' => false, 'message' => 'No se detectaron cambios para actualizar.']);
        } else {
            echo json_encode(['success' => true, 'message' => 'Usuario actualizado correctamente.']);
        }
    } else {
        throw new Exception("Error al actualizar: " . $stmt->error);
    }

    $stmt->close();
    $conexion->close();
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
