<?php

session_start();
require_once '../includes/db.php'; // Ajusta la ruta a tu archivo de conexión

header('Content-Type: application/json');

// Verifica que el usuario esté autenticado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Sesión no válida.']);
    exit;
}

$usuario_id = $_SESSION['usuario_id'];
$actualPassword = $_POST['actualPassword'] ?? '';
$newPassword = $_POST['newPassword'] ?? '';
$confirmPassword = $_POST['confirmPassword'] ?? '';

// Validación básica
if (empty($actualPassword) || empty($newPassword) || empty($confirmPassword)) {
    echo json_encode(['status' => 'error', 'message' => 'Todos los campos son obligatorios.']);
    exit;
}

if ($newPassword !== $confirmPassword) {
    echo json_encode(['status' => 'error', 'message' => 'Las contraseñas nuevas no coinciden.']);
    exit;
}

// Validación de seguridad (mínimo 8 caracteres, una mayúscula, una minúscula y un número)
if (!preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[-_@$!%*?&])[A-Za-z\d\-_@$!%*?&]{8,}$/', $newPassword)) {
    echo json_encode(['status' => 'error', 'message' => 'La nueva contraseña debe tener al menos 8 caracteres, incluir una mayúscula, una minúscula y un número.']);
    exit;
}
try {
    // Verificar contraseña actual
    $stmt = $conn->prepare("SELECT password FROM usuarios WHERE usuario_id = ?");
    $stmt->bind_param('i', $usuario_id);
    $stmt->execute();
    $stmt->bind_result($hash_actual);
    $stmt->fetch();
    $stmt->close();

    if (!$hash_actual || !password_verify($actualPassword, $hash_actual)) {
        echo json_encode(['status' => 'error', 'message' => 'La contraseña actual es incorrecta.']);
        exit;
    }

    // Generar nuevo hash y actualizar
    $nuevo_hash = password_hash($newPassword, PASSWORD_DEFAULT);

    $stmt = $conn->prepare("UPDATE usuarios SET password = ? WHERE usuario_id = ?");
    $stmt->bind_param('si', $nuevo_hash, $usuario_id);

    if ($stmt->execute()) {
        echo json_encode(['status' => 'success', 'message' => 'Contraseña actualizada correctamente.']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Error al actualizar la contraseña.']);
    }

    $stmt->close();
    $conn->close();
} catch (Exception $e) {
    echo json_encode(['status' => 'error', 'message' => 'Error inesperado: ' . $e->getMessage()]);
}
