<?php
require '../config/config.php';

$search = $_GET['q'] ?? '';
$searchTerm = '%' . $search . '%';

$sql = "SELECT promotoria_id AS id, nombre_promotoria AS nombre 
        FROM promotorias 
        WHERE nombre_promotoria LIKE ? 
        LIMIT 20;";

$stmt = $conexion->prepare($sql);
$stmt->bind_param("s", $searchTerm);
$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

header('Content-Type: application/json');
echo json_encode($data);

$stmt->close();
$conexion->close();
