<?php
// Iniciar sesión
session_start();

// Incluir archivo de configuración para la conexión a MySQL
require '../config/config.php';

// 🛠️ Configurar conexión persistente
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);




function enviarRespuesta($status, $message, $data = [])
{
    echo json_encode([
        'status' => $status,
        'message' => $message,
        'data' => $data,
    ]);
    exit;
}


if ($_SERVER["REQUEST_METHOD"] !== "POST") {
    enviarRespuesta("error", "Método no permitido.");
}

// Validar que todos los campos estén presentes
$camposRequeridos = [
    'id_curso',
    'audiencia',
    'requisitos',
    'modalidad',
    'evaluacion',
    'objetivos'
];

foreach ($camposRequeridos as $campo) {
    if (!isset($_POST[$campo]) || trim($_POST[$campo]) === '') {
        enviarRespuesta("error", "El campo $campo es requerido.");
    }
}

// Sanitizar y validar los datos
$id_curso = trim($_POST['id_curso']);
$audiencia = trim($_POST['audiencia']);
$requisitos = trim($_POST['requisitos']);
$modalidad = trim($_POST['modalidad']);
$evaluacion = trim($_POST['evaluacion']);
$objetivos = trim($_POST['objetivos']);

try {
    // Verificar si el ID del empleado ya existe
    $sql = "SELECT curso_id FROM detalles_curso WHERE curso_id = ?";
    $stmt = $conexion->prepare($sql);

    if (!$stmt) {
        throw new Exception("Error en la preparación de la consulta.");
    }

    $stmt->bind_param("s", $id_curso);
    $stmt->execute();
    $result = $stmt->get_result();
    $errores = [];

    while ($row = $result->fetch_assoc()) {
        if ($row['curso_id'] === $id_curso) {
            $errores[] = "El curso que deceas agregar ya cuenta con su informacion detallada.";
        }
    }

    $stmt->close();

    if (!empty($errores)) {
        enviarRespuesta("error", implode(" ", $errores)); // Unir mensajes en una sola respuesta
    }


    // Insertar el nuevo empleado
    $sql = "INSERT INTO detalles_curso (
                curso_id, objetivos_aprendizaje, audiencia_objetivo, requisitos_previos,
                modalidad, evaluacion
            ) VALUES (
                ?, ?, ?, ?, ?, ?
            )";
    $stmt = $conexion->prepare($sql);
    if (!$stmt) {
        throw new Exception("Error en la preparación de la consulta.");
    }

    $stmt->bind_param(
        "isssss", // 
        $id_curso,
        $objetivos,
        $audiencia,
        $requisitos,
        $modalidad, // 
        $evaluacion,
    );

    if ($stmt->execute()) {
        enviarRespuesta("success", "Detalles registrados correctamente.");
    } else {
        throw new Exception("Error al insertar el empleado.");
    }
} catch (Exception $e) {
    enviarRespuesta("error", "Error en el servidor: " . $e->getMessage());
} finally {
    if (isset($stmt)) {
        $stmt->close();
    }
    $conexion->close();
}