<?php
header('Content-Type: application/json');
require '../config/config.php'; // Conexión a MySQL optimizada

// Configurar conexión persistente con tiempo de espera
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);
session_start(); // Iniciar sesión si aún no está iniciada

// Verificar si el usuario está autenticado (ejemplo básico)
if (!isset($_SESSION['usuario_id'])) {
    http_response_code(401); // No autorizado
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

$sql = "SELECT curso_id, curso_title FROM cursos ORDER BY curso_title ASC";
$result = $conexion->query($sql);

$cursos = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $cursos[] = $row;
    }
}

echo json_encode($cursos);

$conexion->close();
