<?php
header('Content-Type: application/json');
require '../config/config.php';

// $response = [
//     "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 0,
//     "recordsTotal" => 0,
//     "recordsFiltered" => 0,
//     "data" => [],
//     "error" => ""
// ];

// try {
//     $start  = isset($_GET['start']) ? intval($_GET['start']) : 0;
//     $length = isset($_GET['length']) ? intval($_GET['length']) : 10;
//     $search = isset($_GET['search']['value']) ? trim($_GET['search']['value']) : '';

//     if ($conexion->connect_error) {
//         throw new Exception("Error de conexión: " . $conexion->connect_error);
//     }

//     $baseQuery = "
//         FROM titulos_temarios tt LEFT JOIN cursos c ON c.curso_id = tt.curso_id
//     ";

//     // Total sin filtro
//     $stmtTotal = $conexion->prepare("SELECT COUNT(*) AS total $baseQuery");
//     $stmtTotal->execute();
//     $totalResult = $stmtTotal->get_result()->fetch_assoc();
//     $response['recordsTotal'] = intval($totalResult['total']);
//     $stmtTotal->close();

//     // Condición de búsqueda
//     $where = "";
//     $bindTypes = "";
//     $bindValues = [];

//     if (!empty($search)) {
//         $where = "
//             WHERE 
//                 c.curso_title LIKE ? OR 
//                 tt.nom_titulo_temario LIKE ?
//         ";
//         $searchWildcard = "%$search%";
//         $bindTypes = "ss";
//         $bindValues = [$searchWildcard, $searchWildcard];
//     }

//     // Conteo filtrado
//     $stmtFiltered = $conexion->prepare("SELECT COUNT(*) AS filtered $baseQuery $where");
//     if (!empty($search)) {
//         $stmtFiltered->bind_param($bindTypes, ...$bindValues);
//     }
//     $stmtFiltered->execute();
//     $filteredResult = $stmtFiltered->get_result()->fetch_assoc();
//     $response['recordsFiltered'] = intval($filteredResult['filtered']);
//     $stmtFiltered->close();

//     // Datos con paginación
//     $query = "
//         SELECT tt.ID_Titulo, tt.curso_id, c.curso_title ,tt.nom_titulo_temario, tt.descripcion_temario, tt.orden
//         $baseQuery
//         $where
//         ORDER BY tt.ID_Titulo DESC
//         LIMIT ?, ?
//     ";

//     if (!empty($search)) {
//         $bindTypes .= "ii";
//         $bindValues[] = $start;
//         $bindValues[] = $length;
//         $stmtData = $conexion->prepare($query);
//         $stmtData->bind_param($bindTypes, ...$bindValues);
//     } else {
//         $stmtData = $conexion->prepare($query);
//         $stmtData->bind_param("ii", $start, $length);
//     }

//     $stmtData->execute();
//     $result = $stmtData->get_result();

//     while ($row = $result->fetch_assoc()) {
//         $row["acciones"] = '
//             <div class="d-flex justify-content-center gap-2">
//                 <button class="btn btn-sm btn-primary editar-btn" data-id="' . $row['ID_Titulo'] . '">
//                     <i class="bi bi-pencil-square"></i> Editar
//                 </button>
//                 <button class="btn btn-sm btn-danger eliminar-btn" data-id="' . $row['ID_Titulo'] . '">
//                     <i class="bi bi-trash"></i> Eliminar
//                 </button>
//             </div>
//         ';
//         $response['data'][] = $row;
//     }

//     $stmtData->close();
//     $conexion->close();
// } catch (Exception $e) {
//     $response["error"] = $e->getMessage();
// }

// echo json_encode($response);






$draw = isset($_GET['draw']) ? intval($_GET['draw']) : 0;
$start = isset($_GET['start']) ? intval($_GET['start']) : 0;
$length = isset($_GET['length']) ? intval($_GET['length']) : 10;
$search = $_GET['search']['value'] ?? '';

// Buscar cursos
$sqlCursos = "SELECT curso_id, curso_title FROM cursos";
$params = [];
if (!empty($search)) {
    $sqlCursos .= " WHERE curso_title LIKE ?";
    $params[] = "%$search%";
}
$sqlCursos .= " LIMIT ?, ?";
$params[] = $start;
$params[] = $length;

$stmtCursos = $conexion->prepare($sqlCursos);

// Enlazar parámetros dinámicamente
$types = str_repeat("s", count($params) - 2) . "ii";
$stmtCursos->bind_param($types, ...$params);

$stmtCursos->execute();
$resultCursos = $stmtCursos->get_result();

$data = [];
while ($curso = $resultCursos->fetch_assoc()) {
    $curso_id = $curso['curso_id'];

    // Obtener títulos del curso
    $stmtTitulos = $conexion->prepare("SELECT ID_Titulo, nom_titulo_temario, descripcion_temario, orden FROM titulos_temarios WHERE curso_id = ?");
    $stmtTitulos->bind_param("i", $curso_id);
    $stmtTitulos->execute();
    $resTitulos = $stmtTitulos->get_result();

    $titulos = [];
    while ($titulo = $resTitulos->fetch_assoc()) {
        $titulos[] = $titulo;
    }

    $data[] = [
        "curso_title" => $curso['curso_title'],
        "titulos" => $titulos
    ];
}

// Obtener total sin filtro
$resTotal = $conexion->query("SELECT COUNT(*) as total FROM cursos");
$rowTotal = $resTotal->fetch_assoc();
$totalRegistros = $rowTotal['total'] ?? 0;

// Obtener total con filtro
if (!empty($search)) {
    $stmtFiltrado = $conexion->prepare("SELECT COUNT(*) as total FROM cursos WHERE curso_title LIKE ?");
    $likeSearch = "%$search%";
    $stmtFiltrado->bind_param("s", $likeSearch);
    $stmtFiltrado->execute();
    $resFiltro = $stmtFiltrado->get_result();
    $rowFiltro = $resFiltro->fetch_assoc();
    $totalFiltrados = $rowFiltro['total'] ?? 0;
} else {
    $totalFiltrados = $totalRegistros;
}

echo json_encode([
    "draw" => $draw,
    "recordsTotal" => $totalRegistros,
    "recordsFiltered" => $totalFiltrados,
    "data" => $data
]);

$conexion->close();