<?php
header('Content-Type: application/json');
require '../config/config.php';

$response = [
    "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 0,
    "recordsTotal" => 0,
    "recordsFiltered" => 0,
    "data" => [],
    "error" => ""
];

try {
    $start  = isset($_GET['start']) ? intval($_GET['start']) : 0;
    $length = isset($_GET['length']) ? intval($_GET['length']) : 10;
    $search = isset($_GET['search']['value']) ? trim($_GET['search']['value']) : '';

    if ($conexion->connect_error) {
        throw new Exception("Error de conexión: " . $conexion->connect_error);
    }

    $baseQuery = "
        FROM detalles_curso dc
        LEFT JOIN cursos c ON c.curso_id = dc.curso_id
    ";

    // Total sin filtrar
    $stmtTotal = $conexion->prepare("SELECT COUNT(*) AS total $baseQuery");
    $stmtTotal->execute();
    $totalResult = $stmtTotal->get_result()->fetch_assoc();
    $response['recordsTotal'] = intval($totalResult['total']);
    $stmtTotal->close();

    // Total filtrado + datos
    $where = "";
    $param = "";
    $bindTypes = "";
    $bindValues = [];

    if (!empty($search)) {
        $where = "
            WHERE 
                c.curso_title LIKE ? OR
                dc.objetivos_aprendizaje LIKE ? OR
                dc.audiencia_objetivo LIKE ? OR
                dc.requisitos_previos LIKE ?
        ";
        $searchWildcard = "%$search%";
        $bindTypes = "ssss";
        $bindValues = [$searchWildcard, $searchWildcard, $searchWildcard, $searchWildcard];
    }

    // Conteo filtrado
    $stmtFiltered = $conexion->prepare("SELECT COUNT(*) AS filtered $baseQuery $where");
    if (!empty($search)) {
        $stmtFiltered->bind_param($bindTypes, ...$bindValues);
    }
    $stmtFiltered->execute();
    $filteredResult = $stmtFiltered->get_result()->fetch_assoc();
    $response['recordsFiltered'] = intval($filteredResult['filtered']);
    $stmtFiltered->close();

    // Datos con paginación
    $query = "
        SELECT 
            dc.detalle_id, 
            dc.curso_id, 
            c.curso_title, 
            dc.objetivos_aprendizaje, 
            dc.audiencia_objetivo, 
            dc.requisitos_previos, 
            dc.duracion, 
            dc.modalidad, 
            dc.evaluacion, 
            dc.created_at, 
            dc.updated_at
        $baseQuery 
        $where 
        LIMIT ?, ?
    ";

    // Preparar parámetros con paginación
    $stmtData = $conexion->prepare($query);
    if (!empty($search)) {
        $bindTypes .= "ii";
        $bindValues[] = $start;
        $bindValues[] = $length;
        $stmtData->bind_param($bindTypes, ...$bindValues);
    } else {
        $stmtData->bind_param("ii", $start, $length);
    }

    $stmtData->execute();
    $result = $stmtData->get_result();

    while ($row = $result->fetch_assoc()) {
        // Botones con identificadores para eventos
        $row["acciones"] = '
            <div class="d-flex justify-content-center gap-2">
                <button class="btn btn-sm btn-primary editar-btn" data-id="' . $row['detalle_id'] . '">
                    <i class="bi bi-pencil-square"></i> Editar
                </button>
                <button class="btn btn-sm btn-danger eliminar-btn" data-id="' . $row['detalle_id'] . '">
                    <i class="bi bi-trash"></i> Eliminar
                </button>
            </div>
        ';
        $response['data'][] = $row;
    }

    $stmtData->close();
    $conexion->close();
} catch (Exception $e) {
    $response["error"] = $e->getMessage();
}

echo json_encode($response);