<?php
header('Content-Type: application/json');
require '../config/config.php';

$response = [
    "draw" => isset($_GET['draw']) ? intval($_GET['draw']) : 0,
    "recordsTotal" => 0,
    "recordsFiltered" => 0,
    "data" => [],
    "error" => ""
];

try {
    $start  = isset($_GET['start']) ? intval($_GET['start']) : 0;
    $length = isset($_GET['length']) ? intval($_GET['length']) : 10;
    $search = isset($_GET['search']['value']) ? trim($_GET['search']['value']) : '';

    if ($conexion->connect_error) {
        throw new Exception("Error de conexión: " . $conexion->connect_error);
    }

    $baseQuery = "
        FROM contenidos_temarios ct
        LEFT JOIN titulos_temarios tt ON tt.ID_Titulo = ct.ID_Titulo
    ";

    // Total sin filtro
    $stmtTotal = $conexion->prepare("SELECT COUNT(*) AS total $baseQuery");
    $stmtTotal->execute();
    $totalResult = $stmtTotal->get_result()->fetch_assoc();
    $response['recordsTotal'] = intval($totalResult['total']);
    $stmtTotal->close();

    // Condición de búsqueda
    $where = "";
    $bindTypes = "";
    $bindValues = [];

    if (!empty($search)) {
        $where = "
            WHERE 
                ct.nombre_contenido LIKE ? OR 
                ct.descripcion_contenido LIKE ? OR 
                ct.tipo_material LIKE ? OR
                tt.nom_titulo_temario LIKE ?
        ";
        $searchWildcard = "%$search%";
        $bindTypes = "ssss";
        $bindValues = [$searchWildcard, $searchWildcard, $searchWildcard, $searchWildcard];
    }

    // Conteo filtrado
    $stmtFiltered = $conexion->prepare("SELECT COUNT(*) AS filtered $baseQuery $where");
    if (!empty($search)) {
        $stmtFiltered->bind_param($bindTypes, ...$bindValues);
    }
    $stmtFiltered->execute();
    $filteredResult = $stmtFiltered->get_result()->fetch_assoc();
    $response['recordsFiltered'] = intval($filteredResult['filtered']);
    $stmtFiltered->close();

    // Datos con paginación
    $query = "
        SELECT 
            ct.id_Contenido,
            ct.ID_Titulo,
            tt.nom_titulo_temario,
            ct.nombre_contenido,
            ct.descripcion_contenido,
            ct.tipo_material,
            ct.ubicacion_material,
            ct.duracion_video,
            ct.numero_paginas_PDF,
            ct.Orden
        $baseQuery
        $where
        ORDER BY ct.id_Contenido DESC
        LIMIT ?, ?
    ";

    if (!empty($search)) {
        $bindTypes .= "ii";
        $bindValues[] = $start;
        $bindValues[] = $length;
        $stmtData = $conexion->prepare($query);
        $stmtData->bind_param($bindTypes, ...$bindValues);
    } else {
        $stmtData = $conexion->prepare($query);
        $stmtData->bind_param("ii", $start, $length);
    }

    $stmtData->execute();
    $result = $stmtData->get_result();

    while ($row = $result->fetch_assoc()) {
        $row["acciones"] = '
            <div class="d-flex justify-content-center gap-2">
                <button class="btn btn-sm btn-primary editar-btn" data-id="' . $row['id_Contenido'] . '">
                    <i class="bi bi-pencil-square"></i> Editar
                </button>
                <button class="btn btn-sm btn-danger eliminar-btn" data-id="' . $row['id_Contenido'] . '">
                    <i class="bi bi-trash"></i> Eliminar
                </button>
            </div>
        ';
        $response['data'][] = $row;
    }

    $stmtData->close();
    $conexion->close();
} catch (Exception $e) {
    $response["error"] = $e->getMessage();
}

echo json_encode($response);