<?php
// require_once '../config/config.php'; // Asegúrate de que esta conexión esté bien configurada

// header('Content-Type: application/json');

// try {
//     if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
//         throw new Exception("Petición no válida.");
//     }

//     // Validar entrada
//     $usuario_id = isset($_POST['iduserselect']) ? intval($_POST['iduserselect']) : 0;
//     $curso_id = isset($_POST['idcursoselect']) ? intval($_POST['idcursoselect']) : 0;

//     if ($usuario_id <= 0 || $curso_id <= 0) {
//         throw new Exception("Datos incompletos o inválidos.");
//     }

//     // Verificar si ya existe un registro previo
//     $query = "SELECT usuario_curso_id, intento, estado_curso FROM usuarios_cursos 
//               WHERE usuario_id = ? AND curso_id = ? ORDER BY intento DESC LIMIT 1";

//     $stmt = $conexion->prepare($query);
//     $stmt->bind_param("ii", $usuario_id, $curso_id);
//     $stmt->execute();
//     $result = $stmt->get_result();

//     $nuevo_intento = 1;
//     $debe_crear = true;
//     $fechahoy = date('d/m/Y');

//     if ($result->num_rows > 0) {
//         $row = $result->fetch_assoc();

//         // Si el curso anterior no fue aprobado, permitir nuevo intento
//         if ($row['estado_curso'] !== 'Completado') {
//             $nuevo_intento = $row['intento'] + 1;
//         } else {
//             throw new Exception("Ya completaste este curso exitosamente.");
//         }
//     }

//     // Insertar nuevo intento de curso
//     $insert = "INSERT INTO usuarios_cursos (usuario_id, curso_id, intento, fecha_inscripcion, progreso, estado_curso) 
//                VALUES (?, ?, ?, NOW(), 0, 'En curso')";

//     $stmt_insert = $conexion->prepare($insert);
//     $stmt_insert->bind_param("iii", $usuario_id, $curso_id, $nuevo_intento);

//     if (!$stmt_insert->execute()) {
//         throw new Exception("No se pudo registrar el acceso al curso.");
//     }

//     // Obtener el ID del nuevo registro por si lo necesitas redirigir
//     $nuevo_id = $stmt_insert->insert_id;

//     echo json_encode([
//         "status" => "success",
//         "message" => "Inscripción al curso registrada exitosamente.",
//         "curso_id" => $curso_id,
//         "usuario_curso_id" => $nuevo_id
//     ]);
// } catch (Exception $e) {
//     echo json_encode([
//         "status" => "error",
//         "message" => $e->getMessage()
//     ]);
// }



require_once '../config/config.php'; // Asegúrate de que esta conexión esté bien configurada

header('Content-Type: application/json');

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception("Petición no válida.");
    }

    // Validar entrada
    $usuario_id = isset($_POST['iduserselect']) ? intval($_POST['iduserselect']) : 0;
    $curso_id = isset($_POST['idcursoselect']) ? intval($_POST['idcursoselect']) : 0;

    if ($usuario_id <= 0 || $curso_id <= 0) {
        throw new Exception("Datos incompletos o inválidos.");
    }

    // Verificar si ya existe un registro activo ('En curso') para este usuario y curso
    $query_activo = "SELECT usuario_curso_id FROM usuarios_cursos
                     WHERE usuario_id = ? AND curso_id = ? AND estado_curso = 'En curso'
                     LIMIT 1";

    $stmt_activo = $conexion->prepare($query_activo);
    $stmt_activo->bind_param("ii", $usuario_id, $curso_id);
    $stmt_activo->execute();
    $result_activo = $stmt_activo->get_result();

    if ($result_activo->num_rows > 0) {
        $row_activo = $result_activo->fetch_assoc();
        echo json_encode([
            "status" => "info",
            "message" => "Ya estás inscrito en este curso.",
            "curso_id" => $curso_id,
            "usuario_curso_id" => $row_activo['usuario_curso_id'],
            "redirect" => true // Indica a tu frontend que debe redirigir
        ]);
        exit(); // Detener la ejecución para que no se intente insertar un nuevo registro
    }

    // Si no hay un registro activo, verificar si existe un registro previo (para el intento)
    $query_previo = "SELECT intento, estado_curso FROM usuarios_cursos
                     WHERE usuario_id = ? AND curso_id = ? ORDER BY intento DESC LIMIT 1";

    $stmt_previo = $conexion->prepare($query_previo);
    $stmt_previo->bind_param("ii", $usuario_id, $curso_id);
    $stmt_previo->execute();
    $result_previo = $stmt_previo->get_result();

    $nuevo_intento = 1;

    if ($result_previo->num_rows > 0) {
        $row_previo = $result_previo->fetch_assoc();

        // Si el curso anterior no fue aprobado, permitir nuevo intento
        if ($row_previo['estado_curso'] !== 'Completado') {
            $nuevo_intento = $row_previo['intento'] + 1;
        } else {
            throw new Exception("Ya completaste este curso exitosamente.");
        }
    }

    // Insertar nuevo intento de curso
    $insert = "INSERT INTO usuarios_cursos (usuario_id, curso_id, intento, fecha_inscripcion, progreso, estado_curso)
                VALUES (?, ?, ?, NOW(), 0, 'En curso')";

    $stmt_insert = $conexion->prepare($insert);
    $stmt_insert->bind_param("iii", $usuario_id, $curso_id, $nuevo_intento);

    if (!$stmt_insert->execute()) {
        throw new Exception("No se pudo registrar el acceso al curso.");
    }

    // Obtener el ID del nuevo registro por si lo necesitas redirigir
    $nuevo_id = $stmt_insert->insert_id;

    echo json_encode([
        "status" => "success",
        "message" => "Inscripción al curso registrada exitosamente.",
        "curso_id" => $curso_id,
        "usuario_curso_id" => $nuevo_id,
        "redirect" => true // Indica a tu frontend que debe redirigir al curso
    ]);
} catch (Exception $e) {
    echo json_encode([
        "status" => "error",
        "message" => $e->getMessage()
    ]);
}