<?php
header('Content-Type: application/json');
require '../config/config.php'; // Conexión a MySQL optimizada

// Configurar conexión persistente con tiempo de espera
$conexion->options(MYSQLI_OPT_CONNECT_TIMEOUT, 10);
session_start(); // Iniciar sesión si aún no está iniciada

// Verificar si el usuario está autenticado (ejemplo básico)
if (!isset($_SESSION['usuario_id'])) {
    http_response_code(401); // No autorizado
    echo json_encode(['error' => 'No autorizado']);
    exit;
}

// Verificar y sanitizar los datos recibidos
$promotoria_id = filter_input(INPUT_POST, 'promotoria_id', FILTER_SANITIZE_NUMBER_INT);
$curso_id = filter_input(INPUT_POST, 'curso_id', FILTER_SANITIZE_NUMBER_INT);

if (!$promotoria_id || !$curso_id) {
    http_response_code(400); // Solicitud incorrecta
    echo json_encode(['success' => false, 'message' => 'ID de promotoria o curso no válido.']);
    exit;
}

// Utilizar prepared statement para la eliminación
$sql = "DELETE FROM cursos_promotorias WHERE promotoria_id = ? AND curso_id = ?";
$stmt = $conexion->prepare($sql);
$stmt->bind_param("ii", $promotoria_id, $curso_id);

if ($stmt->execute()) {
    if ($stmt->affected_rows > 0) {
        echo json_encode(['success' => true, 'message' => 'Curso eliminado de la promotoria.']);
    } else {
        echo json_encode(['success' => false, 'message' => 'No se encontró la asignación a eliminar.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Error al eliminar el curso: ' . $stmt->error]);
}

$stmt->close();
$conexion->close();