<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuAdmin.php');
?>
<style>
.card .custom-card {
    border-radius: 0.25rem;
    background-color: var(--custom-white);
    box-shadow: 0px 0px 8px rgba(0, 0, 0, 0.025);
    border: 0;
    position: relative;
    margin-block-end: 1.5rem;
    width: 100%;
}

/* Opcional: Estilo para el contenedor de resultados */
.result-item {
    padding: 10px;
    border: 1px solid #ddd;
    margin-bottom: 5px;
    cursor: pointer;
    background-color: #f8f9fa;
}

.result-item:hover {
    background-color: #e9ecef;
}

#results {
    display: none;
    /* Ocultar inicialmente */
    max-height: 200px;
    overflow-y: auto;
    border: 1px solid #ccc;
    background-color: #fff;
}
</style>



<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Administrador</h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./administrador-general.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Cuestionarios.</h3>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <button class="btn btn-primary mb-3 btn-lg d-flex align-items-center justify-content-center"
                            data-bs-toggle="modal" data-bs-target="#cuestionarioModal"
                            style="font-size: 1.25rem; font-weight: bold;">
                            <i class="fas fa-plus-circle me-2"></i> Cuestionarios
                        </button>
                        <table id="dataTableCuestionario" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Nombre Curso</th>
                                    <th>Nombre Titulo Temario</th>
                                    <th>Nombre Cuestionario</th>
                                    <th>Preguntas</th>
                                    <th>Opciones</th>

                                </tr>
                            </thead>
                            <tbody>
                                <!-- Los documentos se cargarán aquí con AJAX -->
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->
<!-- CSS de Bootstrap 5 -->

<!-- 
<div class="modal fade" id="" tabindex="-1" aria-labelledby="cuestionarioModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content border-0 shadow-lg">

            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <i class="fas fa-info-circle me-3 fs-4"></i>
                    <h5 class="modal-title fw-bold mb-0" id="cuestionarioModalLabel">Creación de Cuestionarios
                    </h5>
                    <button class="btn btn-primary mb-3 btn-lg d-flex align-items-center justify-content-center"
                        data-bs-toggle="modal" data-bs-target="#miModal"
                        style="font-size: 1.25rem; font-weight: bold;">Crear Titulo Cuestionario</button>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Cerrar"></button>
            </div>

            <div class="modal-body p-4">
                <div class="container mt-5">
                    <h2>Agregar Pregunta a Cuestionario</h2>

                    <div class="mb-3">
                        <label for="selectCuestionario" class="form-label">Seleccionar Cuestionario:</label>
                        <select class="form-select" id="selectCuestionario">
                            <option value="" selected>-- Seleccionar Cuestionario --</option>
                        </select>
                    </div>

                    <div id="formularioAgregarPregunta" style="display: none;">
                        <h3 class="mt-4">Crear Nueva Pregunta de Opción Múltiple</h3>
                        <div class="mb-3">
                            <label for="textoPregunta" class="form-label">Texto de la Pregunta</label>
                            <textarea class="form-control" id="textoPregunta" rows="3" required></textarea>
                        </div>
                        <div id="contenedorOpciones">
                            <div class="mb-3 opcion-respuesta">
                                <label class="form-label">Opción 1</label>
                                <div class="input-group">
                                    <input type="text" class="form-control texto-opcion" required>
                                    <div class="input-group-text">
                                        <input type="radio" class="form-check-input es-correcta"
                                            name="respuesta_correcta" value="0" required>
                                        <label class="form-check-label ms-2">Correcta</label>
                                    </div>
                                    <button type="button" class="btn btn-outline-secondary btn-eliminar-opcion"
                                        disabled>
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                            <div class="mb-3 opcion-respuesta">
                                <label class="form-label">Opción 2</label>
                                <div class="input-group">
                                    <input type="text" class="form-control texto-opcion" required>
                                    <div class="input-group-text">
                                        <input type="radio" class="form-check-input es-correcta"
                                            name="respuesta_correcta" value="1">
                                        <label class="form-check-label ms-2">Correcta</label>
                                    </div>
                                    <button type="button" class="btn btn-outline-secondary btn-eliminar-opcion">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <button type="button" class="btn btn-success mb-3" id="btnAgregarOpcion">
                            <i class="bi bi-plus-circle me-2"></i> Añadir Opción
                        </button>
                        <div class="mb-3">
                            <label for="puntajePregunta" class="form-label">Puntaje</label>
                            <input type="number" class="form-control" id="puntajePregunta" value="1" min="0">
                        </div>
                        <button type="button" class="btn btn-primary" id="btnGuardarPregunta">
                            <i class="bi bi-save me-2"></i> Guardar Pregunta
                        </button>
                        <button type="button" class="btn btn-secondary" id="btnCancelarPregunta">
                            <i class="bi bi-arrow-left me-2"></i> Cancelar
                        </button>
                    </div>
                </div>
            </div>


            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                    <i class="fas fa-times me-1"></i> Cerrar
                </button>
            </div>
        </div>
    </div>
</div> -->
<!-- Modal para ver detalles completos -->
<div class="modal fade" id="detalleCuestionarioModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="modalTitle">Detalles del Cuestionario</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                    aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <h6>Curso: <span id="modalTituloCurso" class="fw-bold"></span></h6>
                    <h6>Título/Temario: <span id="modalTituloTemario" class="fw-bold"></span></h6>
                    <h5 class="mt-3">Cuestionario: <span id="modalNombreCuestionario" class="text-primary"></span></h5>
                </div>

                <hr>

                <h5 class="mb-3">Preguntas:</h5>
                <div id="modalPreguntasContainer"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="btnImprimirCuestionario">
                    <i class="bi bi-printer-fill"></i> Imprimir
                </button>
            </div>
        </div>
    </div>
</div>




<div class="modal fade" id="cuestionarioModal" tabindex="-1" aria-labelledby="cuestionarioModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header">
                <h5 class="modal-title" id="cuestionarioModalLabel">Título del Modal</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <ul class="nav nav-tabs" id="miTabLista" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="formulario1-tab" data-bs-toggle="tab"
                            data-bs-target="#formulario1" type="button" role="tab" aria-controls="formulario1"
                            aria-selected="true">Crear Cuestionario</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="formulario2-tab" data-bs-toggle="tab" data-bs-target="#formulario2"
                            type="button" role="tab" aria-controls="formulario2" aria-selected="false">Agregar Preguntas
                            a Cuestionarios</button>
                    </li>
                </ul>
                <div class="tab-content" id="miTabContenido">
                    <div class="tab-pane fade show active" id="formulario1" role="tabpanel"
                        aria-labelledby="formulario1-tab">
                        <div class="container mt-5">
                            <h2 class="text-center">Agregar Cuestionario</h2>
                            <div class="row justify-content-center g-4">
                                <div class="col-md-6">
                                    <form method="post" id="agregarCuestionarioForm">
                                        <div class="mb-3">
                                            <label for="searchInput" class="form-label fw-semibold">
                                                <i class="fas fa-book me-2"></i>Buscar Curso
                                            </label>
                                            <div class="input-group">
                                                <span class="input-group-text bg-primary text-white">
                                                    <i class="fas fa-search"></i>
                                                </span>
                                                <input type="text" id="searchInput" class="form-control"
                                                    placeholder="Escribe para buscar..." autocomplete="off"
                                                    autocorrect="off" autocapitalize="off" spellcheck="false">
                                            </div>
                                            <input type="hidden" id="searchInputID" name="searchInputID">
                                            <div id="results" class="list-group mt-2 shadow-sm"
                                                style="max-height: 200px; overflow-y: auto;"></div>
                                        </div>
                                        <div class="mb-3">
                                            <label for="nombreTitulostext" class="form-label fw-semibold">
                                                <i class="fas fa-heading me-2"></i>Nombre Cuestionario
                                            </label>
                                            <textarea name="nombreTitulostext" id="nombreTitulostext"
                                                class="form-control" rows="2" style="resize: none;"
                                                placeholder="Ej: Introducción nombre cuestionario..."></textarea>
                                        </div>
                                        <div class="mb-3">
                                            <label for="descripciontext" class="form-label fw-semibold">
                                                <i class="fas fa-heading me-2"></i>Descripción
                                            </label>
                                            <textarea name="descripciontext" id="descripciontext" class="form-control"
                                                rows="2" style="resize: none;" placeholder="Descripción..."></textarea>
                                        </div>
                                        <div class="d-grid">
                                            <button type="submit" class="btn btn-primary py-2 fw-bold">
                                                <i class="fas fa-save me-2"></i>Agregar Cuestionario
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="tab-pane fade" id="formulario2" role="tabpanel" aria-labelledby="formulario2-tab">
                        <!-- agregar preguntas -->
                        <div class="container mt-5">
                            <h2>Agregar Pregunta a Cuestionario</h2>

                            <div class="mb-3">
                                <label for="selectCuestionario" class="form-label">Seleccionar Cuestionario:</label>
                                <select class="form-select" id="selectCuestionario">
                                    <option value="" selected>-- Seleccionar Cuestionario --</option>
                                </select>
                            </div>

                            <div id="formularioAgregarPregunta" style="display: none;">
                                <h3 class="mt-4">Crear Nueva Pregunta de Opción Múltiple</h3>
                                <div class="mb-3">
                                    <label for="textoPregunta" class="form-label">Texto de la Pregunta</label>
                                    <textarea class="form-control" id="textoPregunta" rows="3" required></textarea>
                                </div>
                                <div id="contenedorOpciones">
                                    <div class="mb-3 opcion-respuesta">
                                        <label class="form-label">Opción 1</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control texto-opcion" required>
                                            <div class="input-group-text">
                                                <input type="radio" class="form-check-input es-correcta"
                                                    name="respuesta_correcta" value="0" required>
                                                <label class="form-check-label ms-2">Correcta</label>
                                            </div>
                                            <button type="button" class="btn btn-outline-secondary btn-eliminar-opcion"
                                                disabled>
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="mb-3 opcion-respuesta">
                                        <label class="form-label">Opción 2</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control texto-opcion" required>
                                            <div class="input-group-text">
                                                <input type="radio" class="form-check-input es-correcta"
                                                    name="respuesta_correcta" value="1">
                                                <label class="form-check-label ms-2">Correcta</label>
                                            </div>
                                            <button type="button" class="btn btn-outline-secondary btn-eliminar-opcion">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-success mb-3" id="btnAgregarOpcion">
                                    <i class="bi bi-plus-circle me-2"></i> Añadir Opción
                                </button>
                                <div class="mb-3">
                                    <label for="puntajePregunta" class="form-label">Puntaje</label>
                                    <input type="number" class="form-control" id="puntajePregunta" value="1" min="0">
                                </div>
                                <button type="button" class="btn btn-primary" id="btnGuardarPregunta">
                                    <i class="bi bi-save me-2"></i> Guardar Pregunta
                                </button>
                                <button type="button" class="btn btn-secondary" id="btnCancelarPregunta">
                                    <i class="bi bi-arrow-left me-2"></i> Cancelar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    // Inicialización de DataTable
    if ($.fn.DataTable.isDataTable('#dataTableCuestionario')) {
        $('#dataTableCuestionario').DataTable().clear().destroy();
    }

    const table = $('#dataTableCuestionario').DataTable({
        "processing": true,
        "serverSide": true,
        "ajax": {
            "url": "../../../../controllers/obtenerCuestionariosControllers.php",
            "type": "GET",
            "data": function(d) {
                // Agregar parámetros adicionales si es necesario
                d.curso_id = $('#cursoIdFilter').val(); // Asume que tienes un filtro por curso
            },
            "dataSrc": function(json) {
                if (json.error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error al cargar los datos',
                        text: json.error
                    });
                    return [];
                }

                // Transformar los datos para que coincidan con la estructura esperada
                return json.data.map(item => {
                    return {
                        curso_id: item.curso.id,
                        nombre_curso: item.curso.nombre,
                        ID_Titulo: item.titulo_temario.id,
                        nombre_titulo_temario: item.titulo_temario.nombre,
                        cuestionario_id: item.cuestionario.id,
                        nombre_cuestionario: item.cuestionario.nombre,
                        total_preguntas: item.preguntas.length,
                        puntaje_total: item.preguntas.reduce((sum, p) => sum + parseFloat(p
                            .puntaje), 0)
                    };
                });
            }
        },
        "columns": [{
                "data": "nombre_curso",
                "title": "Curso"
            },
            {
                "data": "nombre_titulo_temario",
                "title": "Título/Temario"
            },
            {
                "data": "nombre_cuestionario",
                "title": "Cuestionario"
            },
            {
                "data": "total_preguntas",
                "title": "Preguntas",
                "className": "text-center"
            },
            {
                "data": "puntaje_total",
                "title": "Puntaje Total",
                "className": "text-center",
                "render": function(data) {
                    return parseFloat(data).toFixed(2);
                }
            },
            {
                "data": null,
                "title": "Acciones",
                "orderable": false,
                "render": function(data, type, row) {
                    return `
                        <div class="d-flex justify-content-center gap-2">
                            <button class="btn btn-sm btn-primary btnVerDetalles" 
                                data-curso-id="${row.curso_id}"
                                data-titulo-id="${row.ID_Titulo}"
                                data-cuestionario-id="${row.cuestionario_id}">
                                <i class="bi bi-eye-fill">${row.cuestionario_id}</i> Ver
                            </button>
                            <button class="btn btn-sm btn-warning btnEditar" 
                                data-cuestionario-id="${row.cuestionario_id}">
                                <i class="bi bi-pencil"></i> Editar
                            </button>
                            <button class="btn btn-sm btn-danger btnEliminar" 
                                data-cuestionario-id="${row.cuestionario_id}">
                                <i class="bi bi-trash"></i> Eliminar
                            </button>
                        </div>
                    `;
                }
            }
        ],
        "language": {
            "sProcessing": "Procesando...",
            "sLengthMenu": "Mostrar _MENU_ registros",
            "sZeroRecords": "No se encontraron resultados",
            "sEmptyTable": "No hay datos disponibles",
            "sInfo": "Mostrando _START_ a _END_ de _TOTAL_ registros",
            "sInfoEmpty": "Mostrando 0 a 0 de 0 registros",
            "sInfoFiltered": "(filtrado de _MAX_ registros)",
            "sSearch": "Buscar:",
            "oPaginate": {
                "sFirst": "Primero",
                "sPrevious": "Anterior",
                "sNext": "Siguiente",
                "sLast": "Último"
            }
        },
        "paging": true,
        "pageLength": 10,
        "lengthChange": true,
        "info": true,
        "autoWidth": false,
        "drawCallback": function(settings) {
            // Inicializar tooltips después de cada dibujo de la tabla
            $('[data-bs-toggle="tooltip"]').tooltip();
        }
    });



    // Evento para editar
    $('#dataTableCuestionario tbody').on('click', '.btnEditar', function() {
        const cuestionarioId = $(this).data('cuestionario-id');
        abrirModalEdicion(cuestionarioId);
    });

    // Evento para eliminar
    $('#dataTableCuestionario tbody').on('click', '.btnEliminar', function() {
        const cuestionarioId = $(this).data('cuestionario-id');

        Swal.fire({
            title: '¿Estás seguro?',
            text: "Esta acción eliminará el cuestionario y todas sus preguntas.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, eliminar',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                eliminarCuestionario(cuestionarioId);
            }
        });
    });

    // Función para cargar detalles completos
    function cargarDetallesCompletos(cursoId, tituloId, cuestionarioId) {
        // Mostrar loader
        $('#loaderModal').removeClass('d-none');

        $.ajax({
            url: '../../../../controllers/obtenerDetalleCuestionarioController.php',
            type: 'GET',
            dataType: 'json',
            data: {
                curso_id: cursoId,
                titulo_id: tituloId,
                cuestionario_id: cuestionarioId
            },
            success: function(response) {
                $('#loaderModal').addClass('d-none');

                if (response.success) {
                    mostrarDetallesEnModal(response.data);
                } else {
                    Swal.fire('Error', response.error || 'Error al cargar los detalles', 'error');
                }
            },
            error: function(xhr, status, error) {
                $('#loaderModal').addClass('d-none');
                Swal.fire('Error', 'No se pudo conectar con el servidor: ' + error, 'error');
                console.error('Error en la solicitud:', status, error);
            }
        });
    }

    // Función para mostrar detalles en modal
    function mostrarDetallesEnModal(detalles) {
        // Inicializar modal
        const modal = new bootstrap.Modal(document.getElementById('detalleCuestionarioModal'));

        // Llenar datos básicos
        $('#modalTituloCurso').text(detalles.curso.nombre);
        $('#modalTituloTemario').text(detalles.titulo_temario.nombre);
        $('#modalNombreCuestionario').text(detalles.cuestionario.nombre);
        $('#modalDescripcionCuestionario').text(detalles.cuestionario.descripcion || 'Sin descripción');
        $('#modalTotalPreguntas').text(detalles.cuestionario.total_preguntas);
        $('#modalPuntajeTotal').text(detalles.cuestionario.puntaje_total);

        // Llenar preguntas
        const preguntasContainer = $('#modalPreguntasContainer');
        preguntasContainer.empty();

        if (detalles.preguntas.length === 0) {
            preguntasContainer.html('<div class="alert alert-info">Este cuestionario no tiene preguntas</div>');
            modal.show();
            return;
        }

        detalles.preguntas.forEach((pregunta, index) => {
            const preguntaHtml = `
            <div class="card mb-3">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h6 class="mb-0">
                        <span class="badge bg-primary me-2">${index + 1}</span>
                        ${pregunta.texto}
                    </h6>
                    <span class="badge bg-success">Puntaje: ${pregunta.puntaje}</span>
                </div>
                <div class="card-body">
                    ${pregunta.opciones.length > 0 ? 
                        '<ul class="list-group list-group-flush">' + 
                            pregunta.opciones.map(opcion => `
                                <li class="list-group-item ${opcion.es_correcta ? 'list-group-item-success' : ''}">
                                    <div class="form-check">
                                        <input class="form-check-input" type="${pregunta.opciones.filter(o => o.es_correcta).length > 1 ? 'checkbox' : 'radio'}" 
                                               disabled ${opcion.es_correcta ? 'checked' : ''}>
                                        <label class="form-check-label">
                                            ${opcion.texto}
                                            ${opcion.es_correcta ? ' <i class="fas fa-check-circle text-success ms-2"></i>' : ''}
                                        </label>
                                    </div>
                                </li>
                            `).join('') +
                        '</ul>' : 
                        '<div class="alert alert-warning mb-0">Esta pregunta no tiene opciones definidas</div>'
                    }
                </div>
            </div>
        `;

            preguntasContainer.append(preguntaHtml);
        });

        // Mostrar modal
        modal.show();
    }

    // Evento para ver detalles
    $('#dataTableCuestionario tbody').on('click', '.btnVerDetalles', function() {
        const cursoId = $(this).data('curso-id');
        const tituloId = $(this).data('titulo-id');
        const cuestionarioId = $(this).data('cuestionario-id');

        cargarDetallesCompletos(cursoId, tituloId, cuestionarioId);
    });

    // Función para eliminar cuestionario
    function eliminarCuestionario(cuestionarioId) {
        $.ajax({
            url: '../../../../controllers/eliminarCuestionarioController.php',
            type: 'POST',
            data: {
                cuestionario_id: cuestionarioId
            },
            success: function(response) {
                const res = JSON.parse(response);
                if (res.success) {
                    Swal.fire('Eliminado', res.message, 'success');
                    table.ajax.reload(null, false);
                } else {
                    Swal.fire('Error', res.message, 'error');
                }
            },
            error: function() {
                Swal.fire('Error', 'No se pudo conectar con el servidor', 'error');
            }
        });
    }

    // Función para abrir modal de edición
    function abrirModalEdicion(cuestionarioId) {
        // Implementar lógica para cargar datos de edición
        console.log("Abrir edición para cuestionario ID:", cuestionarioId);
        // Aquí podrías cargar otro endpoint que te devuelva los datos para editar
        // y luego mostrar un modal de edición
    }
});
</script>
<script>
//SCRIPT PARA LA BUSQUEDA DE USUARIOS.
$(document).ready(function() {
    // Evento de clic para mostrar resultados
    $('#searchInput').on('focus', function() {
        $('#results').fadeIn(); // Mostrar el contenedorsultados

        // Realizar la búsqueda cuando el input recibe foco (mostrar todos los resultados si el input está vacío)
        const query = $(this).val(); // Tomar el valor actual del input

        // Si el campo está vacío, mostrar todos los resultados
        if (query === '') {
            fetchResults('');
        }
    });

    // Evento de búsqueda en tiempo real
    $('#searchInput').on('keyup', function() {
        const query = $(this).val();

        // Llamada AJAX al servidor
        fetchResults(query);
    });

    // Función para hacer la llamada AJAX y actualizar los resultados
    function fetchResults(query) {
        $.ajax({
            url: '../../../../controllers/searchUsuariosController.php', // Archivo PHP que maneja la búsqueda
            method: 'GET',
            data: {
                q: query
            }, // Enviar término de búsqueda
            dataType: 'json',
            success: function(data) {
                //console.log(data);
                let resultsHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        resultsHTML += `
                            <div class="result-item" data-id="${item.curso_id}" data-name="${item.curso_title}">
                                <strong>${item.curso_title}</strong><br>
                            </div>
                        `;
                    });
                } else {
                    resultsHTML =
                        '<p class="text-muted px-2">No se encontraron resultados</p>';
                }

                $('#results').html(resultsHTML);
            },
            error: function(xhr, status, error) {
                console.error("Error:", error);
                $('#results').html(
                    `<p class="text-danger px-2">Error al buscar datos: ${error}</p>`
                );
            }
        });
    }

    // Ocultar resultados al hacer clic en un resultado
    $(document).on("click", ".result-item", function() {
        const id = $(this).data("id");
        const name = $(this).data("name");
        const nombrecompleto = name;
        $("#searchInput").val(nombrecompleto); // Poner el id en el input
        $("#searchInputID").val(id); // Poner el id en el input
        $("#results").fadeOut(); // Ocultar los resultados
    });

    // Ocultar resultados al hacer clic fuera del input
    $(document).on('click', function(e) {
        if (!$(e.target).closest('#searchInput, #results').length) {
            $('#results').fadeOut();
        }
    });
});

document.addEventListener('DOMContentLoaded', function() {
    const selectCuestionario = document.getElementById('selectCuestionario');
    const formularioAgregarPregunta = document.getElementById('formularioAgregarPregunta');
    const textoPreguntaInput = document.getElementById('textoPregunta');
    const contenedorOpciones = document.getElementById('contenedorOpciones');
    const btnAgregarOpcion = document.getElementById('btnAgregarOpcion');
    const puntajePreguntaInput = document.getElementById('puntajePregunta');
    const btnGuardarPregunta = document.getElementById('btnGuardarPregunta');
    const btnCancelarPregunta = document.getElementById('btnCancelarPregunta');

    // Variables para control de opciones
    let opcionesCounter = 2; // Comenzamos con 2 opciones iniciales
    const MIN_OPCIONES = 2;
    const MAX_OPCIONES = 10;

    // Función para cargar los cuestionarios disponibles
    function cargarCuestionarios() {
        fetch('../../../../controllers/obtener_cuestionarios.php')
            .then(response => response.json())
            .then(data => {
                selectCuestionario.innerHTML =
                    '<option value="" selected>-- Seleccionar Cuestionario --</option>';
                data.forEach(cuestionario => {
                    const option = document.createElement('option');
                    option.value = cuestionario.cuestionario_id;
                    option.textContent = cuestionario.titulo;
                    selectCuestionario.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error al cargar cuestionarios:', error);
                Swal.fire('Error', 'No se pudieron cargar los cuestionarios.', 'error');
            });
    }

    // Mostrar el formulario al seleccionar un cuestionario
    selectCuestionario.addEventListener('change', function() {
        if (this.value) {
            formularioAgregarPregunta.style.display = 'block';
            resetearFormulario();
        } else {
            formularioAgregarPregunta.style.display = 'none';
        }
    });

    // Función para resetear el formulario
    function resetearFormulario() {
        textoPreguntaInput.value = '';
        puntajePreguntaInput.value = 1;
        opcionesCounter = MIN_OPCIONES;

        contenedorOpciones.innerHTML = '';

        // Agregar las dos opciones iniciales
        for (let i = 1; i <= MIN_OPCIONES; i++) {
            agregarOpcion(i);
        }

        // Deshabilitar botones de eliminar en las primeras dos opciones
        const primerosBotones = contenedorOpciones.querySelectorAll('.btn-eliminar-opcion');
        primerosBotones[0].disabled = true;
        primerosBotones[1].disabled = true;

        actualizarEstadoBotonAgregar();
    }

    // Función para agregar una nueva opción
    function agregarOpcion(numeroOpcion) {
        const nuevaOpcionDiv = document.createElement('div');
        nuevaOpcionDiv.classList.add('mb-3', 'opcion-respuesta', 'animate__animated', 'animate__fadeIn');

        nuevaOpcionDiv.innerHTML = `
        <div class="card border-light shadow-sm">
            <div class="card-body p-3">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <label class="form-label fw-semibold">Opción ${numeroOpcion}</label>
                    <button type="button" class="btn btn-sm btn-outline-danger btn-eliminar-opcion">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                <div class="input-group mb-2">
                    <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                    <input type="text" class="form-control texto-opcion" required>
                </div>
                <div class="form-check">
                    <input class="form-check-input es-correcta" type="radio" 
                        name="respuesta_correcta" value="${numeroOpcion - 1}" id="correcta-${numeroOpcion}">
                    <label class="form-check-label" for="correcta-${numeroOpcion}">
                        Respuesta correcta
                    </label>
                </div>
            </div>
        </div>
    `;

        contenedorOpciones.appendChild(nuevaOpcionDiv);

        // Configurar evento para el botón de eliminar
        const btnEliminar = nuevaOpcionDiv.querySelector('.btn-eliminar-opcion');
        btnEliminar.addEventListener('click', function() {
            eliminarOpcion(nuevaOpcionDiv);
        });
    }

    // Función para eliminar una opción
    function eliminarOpcion(opcionDiv) {
        if (contenedorOpciones.children.length <= MIN_OPCIONES) {
            Swal.fire('Advertencia', `Debe haber al menos ${MIN_OPCIONES} opciones.`, 'warning');
            return;
        }

        // Animación de eliminación
        opcionDiv.classList.add('animate__animated', 'animate__fadeOut');

        setTimeout(() => {
            // Verificar si estamos eliminando la opción correcta seleccionada
            const radioCorrecto = opcionDiv.querySelector('.es-correcta:checked');
            if (radioCorrecto) {
                // Seleccionar la primera opción como correcta por defecto
                const primeraOpcion = contenedorOpciones.firstChild;
                if (primeraOpcion) {
                    primeraOpcion.querySelector('.es-correcta').checked = true;
                }
            }

            opcionDiv.remove();
            opcionesCounter--;

            // Renumerar las opciones restantes
            renumerarOpciones();
            actualizarEstadoBotonAgregar();
        }, 300);
    }

    // Función para renumerar las opciones
    function renumerarOpciones() {
        const opciones = contenedorOpciones.querySelectorAll('.opcion-respuesta');

        opciones.forEach((opcion, index) => {
            const nuevoNumero = index + 1;

            // Actualizar etiqueta
            opcion.querySelector('.form-label').textContent = `Opción ${nuevoNumero}`;

            // Actualizar radio button
            const radio = opcion.querySelector('.es-correcta');
            radio.value = index;
            radio.id = `correcta-${nuevoNumero}`;
            opcion.querySelector('label[for]').htmlFor = `correcta-${nuevoNumero}`;

            // Habilitar/deshabilitar botón de eliminar
            const btnEliminar = opcion.querySelector('.btn-eliminar-opcion');
            btnEliminar.disabled = index < MIN_OPCIONES;
        });
    }

    // Función para actualizar el estado del botón de agregar
    function actualizarEstadoBotonAgregar() {
        if (opcionesCounter >= MAX_OPCIONES) {
            btnAgregarOpcion.disabled = true;
            btnAgregarOpcion.classList.remove('btn-primary');
            btnAgregarOpcion.classList.add('btn-secondary');
            btnAgregarOpcion.innerHTML = '<i class="bi bi-exclamation-circle me-1"></i> Límite alcanzado';
        } else {
            btnAgregarOpcion.disabled = false;
            btnAgregarOpcion.classList.remove('btn-secondary');
            btnAgregarOpcion.classList.add('btn-primary');
            btnAgregarOpcion.innerHTML = '<i class="bi bi-plus-circle me-1"></i> Agregar Opción';
        }
    }

    // Evento para agregar nueva opción
    btnAgregarOpcion.addEventListener('click', function() {
        if (opcionesCounter >= MAX_OPCIONES) {
            Swal.fire({
                icon: 'warning',
                title: 'Límite alcanzado',
                text: `No puedes agregar más de ${MAX_OPCIONES} opciones`,
                confirmButtonColor: '#3085d6'
            });
            return;
        }

        opcionesCounter++;
        agregarOpcion(opcionesCounter);
        actualizarEstadoBotonAgregar();
    });

    // Guardar la pregunta y sus opciones
    // Guardar la pregunta y sus opciones
    btnGuardarPregunta.addEventListener('click', async function() {
        // Mostrar indicador de carga
        const loadingSwal = Swal.fire({
            title: 'Guardando pregunta',
            html: 'Por favor espere...',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        try {
            // 1. Obtener y validar datos básicos
            const cuestionarioId = selectCuestionario.value;
            const textoPregunta = textoPreguntaInput.value.trim();
            const puntaje = parseFloat(puntajePreguntaInput.value) ||
                1; // Valor por defecto 1 si no es número

            if (!cuestionarioId) {
                await Swal.fire('Selección requerida', 'Por favor, seleccione un cuestionario.',
                    'warning');
                selectCuestionario.focus();
                return;
            }

            if (!textoPregunta) {
                await Swal.fire('Texto requerido', 'Por favor, ingrese el texto de la pregunta.',
                    'warning');
                textoPreguntaInput.focus();
                return;
            }

            // 2. Procesar opciones con validaciones
            const opciones = [];
            let respuestaCorrectaSeleccionada = false;
            let opcionesVacias = 0;

            const opcionesElements = contenedorOpciones.querySelectorAll('.opcion-respuesta');

            // Validar mínimo de opciones
            if (opcionesElements.length < 2) {
                await Swal.fire('Opciones insuficientes',
                    'Debe haber al menos dos opciones de respuesta.', 'warning');
                return;
            }

            // Procesar cada opción
            opcionesElements.forEach((opcionDiv, index) => {
                const textoOpcion = opcionDiv.querySelector('.texto-opcion').value.trim();
                const esCorrecta = opcionDiv.querySelector('.es-correcta:checked') !== null;

                if (!textoOpcion) {
                    opcionesVacias++;
                    opcionDiv.querySelector('.texto-opcion').classList.add('is-invalid');
                } else {
                    opcionDiv.querySelector('.texto-opcion').classList.remove('is-invalid');
                }

                opciones.push({
                    texto_opcion: textoOpcion,
                    es_correcta: esCorrecta ? 1 : 0,
                    orden: index + 1
                });

                if (esCorrecta) {
                    respuestaCorrectaSeleccionada = true;
                }
            });

            // Validar opciones vacías
            if (opcionesVacias > 0) {
                await Swal.fire('Opciones incompletas',
                    `Tiene ${opcionesVacias} opción(es) sin texto. Por favor complete todas las opciones.`,
                    'warning');
                return;
            }

            // Validar respuesta correcta
            if (!respuestaCorrectaSeleccionada) {
                await Swal.fire('Respuesta correcta requerida',
                    'Por favor, marque una opción como correcta.', 'warning');
                return;
            }

            // 3. Preparar datos para enviar
            const data = {
                cuestionario_id: cuestionarioId,
                texto_pregunta: textoPregunta,
                puntaje: puntaje,
                opciones: opciones
            };
            console.log(data);

            // 4. Enviar datos al servidor
            const response = await fetch('../../../../controllers/guardar_pregunta.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify(data)
            });

            const result = await response.json();

            // Cerrar loading manualmente
            await loadingSwal.close();

            // 5. Manejar respuesta
            if (result.success) {
                await Swal.fire({
                    title: '¡Éxito!',
                    text: result.message || 'Pregunta guardada correctamente',
                    icon: 'success',
                    confirmButtonText: 'Aceptar',
                    willClose: () => {
                        resetearFormulario();
                        selectCuestionario.focus();
                        $('#dataTableCuestionario').DataTable().ajax.reload(null,
                            false);
                    }
                });
            } else {
                await Swal.fire({
                    title: 'Error al guardar',
                    text: result.message || 'Hubo un problema al guardar la pregunta',
                    icon: 'error',
                    confirmButtonText: 'Entendido'
                });
            }
        } catch (error) {
            console.error('Error al guardar la pregunta:', error);
            await loadingSwal.close();
            await Swal.fire({
                title: 'Error inesperado',
                text: 'Ocurrió un error al intentar guardar la pregunta. Por favor intente nuevamente.',
                icon: 'error',
                confirmButtonText: 'Entendido'
            });
        }
    });

    // Función para resetear el formulario (reutilizable)
    function resetearFormulario() {
        textoPreguntaInput.value = '';
        puntajePreguntaInput.value = 1;

        // Restablecer opciones a las 2 iniciales
        contenedorOpciones.innerHTML = `
        <div class="mb-3 opcion-respuesta">
            <div class="card border-light shadow-sm">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <label class="form-label fw-semibold">Opción 1</label>
                        <button type="button" class="btn btn-sm btn-outline-secondary btn-eliminar-opcion" disabled>
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                    <div class="input-group mb-2">
                        <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                        <input type="text" class="form-control texto-opcion" required>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input es-correcta" type="radio" 
                            name="respuesta_correcta" value="0" id="correcta-1" checked>
                        <label class="form-check-label" for="correcta-1">
                            Respuesta correcta
                        </label>
                    </div>
                </div>
            </div>
        </div>
        <div class="mb-3 opcion-respuesta">
            <div class="card border-light shadow-sm">
                <div class="card-body p-3">
                    <div class="d-flex justify-content-between align-items-center mb-2">
                        <label class="form-label fw-semibold">Opción 2</label>
                        <button type="button" class="btn btn-sm btn-outline-danger btn-eliminar-opcion">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                    <div class="input-group mb-2">
                        <span class="input-group-text"><i class="bi bi-card-text"></i></span>
                        <input type="text" class="form-control texto-opcion" required>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input es-correcta" type="radio" 
                            name="respuesta_correcta" value="1" id="correcta-2">
                        <label class="form-check-label" for="correcta-2">
                            Respuesta correcta
                        </label>
                    </div>
                </div>
            </div>
        </div>
    `;

        // Restablecer contador
        opcionesCounter = 2;
        actualizarEstadoBotonAgregar();

        // Volver a asignar eventos a los botones de eliminar
        document.querySelectorAll('.btn-eliminar-opcion').forEach(btn => {
            if (!btn.disabled) {
                btn.addEventListener('click', function() {
                    eliminarOpcion(this.closest('.opcion-respuesta'));
                });
            }
        });
    }

    btnCancelarPregunta.addEventListener('click', function() {
        formularioAgregarPregunta.style.display = 'none';
        selectCuestionario.value = '';
        textoPreguntaInput.value = '';
        contenedorOpciones.innerHTML = `
                <div class="mb-3 opcion-respuesta">
                    <label class="form-label">Opción 1</label>
                    <div class="input-group">
                        <input type="text" class="form-control texto-opcion" required>
                        <div class="input-group-text">
                            <input type="radio" class="form-check-input es-correcta" name="respuesta_correcta" value="0" required>
                            <label class="form-check-label ms-2">Correcta</label>
                        </div>
                        <button type="button" class="btn btn-outline-secondary btn-eliminar-opcion" disabled>
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                </div>
                <div class="mb-3 opcion-respuesta">
                    <label class="form-label">Opción 2</label>
                    <div class="input-group">
                        <input type="text" class="form-control texto-opcion" required>
                        <div class="input-group-text">
                            <input type="radio" class="form-check-input es-correcta" name="respuesta_correcta" value="1">
                            <label class="form-check-label ms-2">Correcta</label>
                        </div>
                        <button type="button" class="btn btn-outline-secondary btn-eliminar-opcion">
                            <i class="bi bi-trash"></i>
                        </button>
                    </div>
                </div>
            `;
        puntajePreguntaInput.value = 1;
    });

    // Cargar los cuestionarios al cargar la página
    cargarCuestionarios();

    $('#agregarCuestionarioForm').submit(function(event) {
        event.preventDefault(); // Evita la recarga de la página al enviar el formulario

        // Obtener los datos del formulario
        var formData = {
            searchInputID: $('#searchInputID').val(),
            nombreTitulostext: $('#nombreTitulostext').val(),
            descripciontext: $('#descripciontext').val()
        };

        $.ajax({
            type: 'POST',
            url: '../../../../controllers/agregarnuevocuestionario.php',
            data: formData,
            dataType: 'json',
            beforeSend: function() {
                Swal.fire({
                    title: 'Guardando...',
                    html: 'Por favor, espera mientras se guarda el cuestionario.',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });
            },
            success: function(response) {
                Swal.close();
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Cuestionario Guardado',
                        text: response.message ||
                            'El cuestionario se ha guardado correctamente.',
                        confirmButtonText: 'OK'
                    }).then((result) => {

                        $('#agregarCuestionarioForm')[0].reset();
                        cargarCuestionarios();


                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error al Guardar',
                        text: response.message ||
                            'Hubo un error al intentar guardar el cuestionario.',
                        confirmButtonText: 'OK'
                    });
                }
            },
            error: function(xhr, status, error) {
                Swal.close();
                console.error("Error en la petición AJAX:", error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error de Conexión',
                    text: 'No se pudo conectar con el servidor. Por favor, intenta de nuevo más tarde.',
                    confirmButtonText: 'OK'
                });
            }
        });
    });
});
</script>

<?php require('../../components/FooterAdmin.php'); ?>