<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuAdmin.php'); ?>
<style>
.card {
    border: 0;
    box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
    border-radius: 0.5rem;
}

.card-header {
    background-color: #28a745;
    /* Verde para Promotorias */
    color: white;
    border-bottom: none;
    border-radius: 0.5rem 0.5rem 0 0;
}

.btn-success {
    background-color: #28a745;
    border-color: #28a745;
}

.btn-success:hover {
    background-color: #1e7e34;
    border-color: #1e7e34;
}

.list-group-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.course-actions button {
    margin-left: 5px;
}

#asignarCursosCard {
    margin-top: 20px;
    border: 1px solid #ced4da;
    border-radius: 0.5rem;
}

#asignarCursosCard .card-header {
    background-color: #f0f0f0;
    color: #333;
    border-bottom: 1px solid #ced4da;
    border-radius: 0.5rem 0.5rem 0 0;
}
</style>
<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">

                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="./administrador-general.php">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!-- Main content -->
        <section class="content">
            <div class="container-fluid">
                <div class="card border-primary shadow">
                    <div
                        class="card-header bg-primary bg-gradient text-white d-flex justify-content-between align-items-center py-3">
                        <h1 class="h4 mb-0">
                            <i class="bi bi-bookmark-check-fill me-2"></i>
                            Asignación de Cursos a Promotorias
                        </h1>
                        <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal"
                            data-bs-target="#modalNuevaPromotoria">
                            <i class="bi bi-plus-lg me-1"></i> Nueva Promotoria
                        </button>
                    </div>

                    <div class="card-body">
                        <!-- Selector de promotoria -->
                        <div class="row mb-4 g-3 align-items-center">
                            <label for="selectPromotoria" class="col-md-3 col-form-label fw-semibold">
                                <i class="bi bi-building me-1"></i> Seleccionar Promotoria:
                            </label>
                            <div class="col-md-9">
                                <div class="input-group">
                                    <select class="form-select shadow-sm" id="selectPromotoria">
                                        <option value="" selected>-- Seleccionar Promotoria --</option>
                                    </select>

                                </div>
                            </div>
                        </div>

                        <!-- Cursos asignados -->
                        <div id="cursosAsignados" class="mt-4">
                            <h2 class="h5 mb-3 text-primary d-flex align-items-center">
                                <i class="bi bi-card-checklist me-2"></i>
                                Cursos Asignados a <span id="nombrePromotoriaSeleccionada"
                                    class="fw-bold ms-1">[Promotoria]</span>
                            </h2>
                            <div class="border rounded">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item d-flex justify-content-center py-3">
                                        <span class="text-muted">
                                            <i class="bi bi-info-circle me-2"></i>
                                            Seleccione una promotoria para ver los cursos asignados.
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <!-- Asignar nuevos cursos -->
                        <div id="asignarCursosCard" class="mt-4 card shadow-sm border-primary">
                            <div class="card-header bg-light d-flex align-items-center py-2">
                                <h3 class="h5 mb-0">
                                    <i class="bi bi-plus-circle-fill text-success me-2"></i>
                                    Asignar Nuevos Cursos
                                </h3>
                            </div>
                            <div class="card-body">
                                <div class="row g-3 align-items-center">
                                    <div class="col-md-8">
                                        <label for="selectCurso" class="form-label fw-semibold">
                                            <i class="bi bi-book me-1"></i> Seleccionar Curso:
                                        </label>
                                        <select class="form-select shadow-sm" id="selectCurso" disabled>
                                            <option value="" selected>-- Seleccionar Promotoria Primero --</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4 pt-3">
                                        <button type="button" class="btn btn-primary w-100" id="btnAsignarCurso"
                                            disabled>
                                            <i class="bi bi-plus-lg me-1"></i> Asignar Curso
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Pie de tarjeta -->
                    <div class="card-footer bg-light py-2">
                        <small class="text-muted">
                            <i class="bi bi-info-circle me-1"></i>
                            Seleccione una promotoría y luego los cursos a asignar
                        </small>
                    </div>
                </div>

                <!-- Estilos adicionales mínimos (puedes ponerlos en tu CSS) -->
                <style>
                .list-group-item {
                    transition: background-color 0.2s;
                }

                .list-group-item:hover {
                    background-color: #f8f9fa;
                }

                .shadow-sm {
                    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075) !important;
                }
                </style>

                <div class="modal fade" id="modalNuevaPromotoria" tabindex="-1"
                    aria-labelledby="modalNuevaPromotoriaLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalNuevaPromotoriaLabel">Nueva Promotoria</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form id="formNuevaPromotoria">
                                    <div class="mb-3">
                                        <label for="nombreNuevaPromotoria" class="form-label">Nombre de la
                                            Promotoria:</label>
                                        <input type="text" class="form-control" id="nombreNuevaPromotoria" required>
                                    </div>
                                    <div class="input-group">
                                        <select class="form-select shadow-sm" id="selectEmpresa">
                                            <option value="" selected>-- Seleccione Empresa --</option>
                                        </select>

                                    </div>
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary"
                                    data-bs-dismiss="modal">Cancelar</button>
                                <button type="button" class="btn btn-primary" id="btnGuardarPromotoria">Guardar
                                    Promotoria</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->
<!-- CSS de Bootstrap 5 -->

<script>
document.addEventListener('DOMContentLoaded', function() {
    const selectPromotoria = document.getElementById('selectPromotoria');
    const selectEmpresa = document.getElementById('selectEmpresa');
    const cursosAsignadosList = document.querySelector('#cursosAsignados ul');
    const nombrePromotoriaSeleccionada = document.getElementById(
        'nombrePromotoriaSeleccionada');
    const selectCurso = document.getElementById('selectCurso');
    const btnAsignarCurso = document.getElementById('btnAsignarCurso');
    const btnGuardarPromotoria = document.getElementById('btnGuardarPromotoria');
    const formNuevaPromotoria = document.getElementById('formNuevaPromotoria');
    const modalNuevaPromotoria = new bootstrap.Modal(document.getElementById(
        'modalNuevaPromotoria'));

    // Funciones AJAX (se implementarán más adelante)
    function cargarPromotorias() {
        fetch('../../../../controllers/obtener_promotorias.php')
            .then(response => response.json())
            .then(data => {
                selectPromotoria.innerHTML =
                    '<option value="" selected>-- Seleccionar Promotoria --</option>';
                data.forEach(promotoria => {
                    const option = document.createElement('option');
                    option.value = promotoria.promotoria_id;
                    option.textContent = promotoria.nombre_promotoria;
                    selectPromotoria.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error al cargar promotorias:', error);
                Swal.fire('Error', 'No se pudieron cargar las promotorias.', 'error');
            });
    }
    // Funciones AJAX (se implementarán más adelante)
    function cargarEmpresas() {
        fetch('../../../../controllers/obtener_empresas.php')
            .then(response => response.json())
            .then(data => {
                selectEmpresa.innerHTML =
                    '<option value="" selected>-- Seleccione la empresa --</option>';
                data.forEach(promotoria => {
                    const option = document.createElement('option');
                    option.value = promotoria.empresa_id;
                    option.textContent = promotoria.nombre_empresa;
                    selectEmpresa.appendChild(option);
                });
            })
            .catch(error => {
                console.error('Error al cargar promotorias:', error);
                Swal.fire('Error', 'No se pudieron cargar las promotorias.', 'error');
            });
    }

    function cargarCursosDisponibles() {
        fetch('../../../../controllers/obtener_cursos.php')
            .then(response => response.json())
            .then(data => {
                selectCurso.innerHTML =
                    '<option value="" selected>-- Seleccionar Curso --</option>';
                data.forEach(curso => {
                    const option = document.createElement('option');
                    option.value = curso.curso_id;
                    option.textContent = curso.curso_title;
                    selectCurso.appendChild(option);
                });
                selectCurso.disabled = false; // Habilitar al cargar los cursos
            })
            .catch(error => {
                console.error('Error al cargar cursos:', error);
                Swal.fire('Error', 'No se pudieron cargar los cursos.', 'error');
            });
    }

    function mostrarCursosAsignados(promotoriaId) {
        cursosAsignadosList.innerHTML = '';
        nombrePromotoriaSeleccionada.textContent = '';
        selectCurso.disabled = true;
        selectCurso.innerHTML =
            '<option value="" selected>-- Seleccionar Promotoria Primero --</option>';
        btnAsignarCurso.disabled = true;

        if (promotoriaId) {
            nombrePromotoriaSeleccionada.textContent = selectPromotoria.options[selectPromotoria
                .selectedIndex].textContent;
            fetch(
                    `../../../../controllers/obtener_cursos_asignados.php?promotoria_id=${promotoriaId}`)
                .then(response => response.json())
                .then(data => {
                    if (data.length > 0) {
                        data.forEach(asignacion => {
                            const listItem = document.createElement('li');
                            listItem.classList.add('list-group-item');
                            listItem.classList.add('list-group-item-secondary');
                            listItem.classList.add('text-black');
                            listItem.classList.add('fw-bold');
                            listItem.innerHTML = `
                                        <span>${asignacion.nombre_curso}</span>
                                        <div class="course-actions">
                                            <button class="btn btn-danger btn-sm btn-eliminar-curso" data-curso-id="${asignacion.curso_id}">
                                                <i class="bi bi-trash"></i> Eliminar
                                            </button>
                                        </div>
                                    `;
                            cursosAsignadosList.appendChild(listItem);
                        });
                    } else {
                        const listItem = document.createElement('li');
                        listItem.classList.add('list-group-item');
                        listItem.textContent = 'No hay cursos asignados a esta promotoria.';
                        cursosAsignadosList.appendChild(listItem);
                    }
                    cargarCursosDisponibles
                        (); // Cargar cursos después de seleccionar la promotoria
                    btnAsignarCurso.disabled = false;
                })
                .catch(error => {
                    console.error('Error al cargar cursos asignados:', error);
                    Swal.fire('Error', 'No se pudieron cargar los cursos asignados.',
                        'error');
                });
        } else {
            const listItem = document.createElement('li');
            listItem.classList.add('list-group-item');
            listItem.textContent = 'Seleccione una promotoria para ver los cursos asignados.';
            cursosAsignadosList.appendChild(listItem);
        }
    }

    function asignarCurso(promotoriaId, cursoId) {
        fetch('../../../../controllers/asignar_curso.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `promotoria_id=${promotoriaId}&curso_id=${cursoId}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('¡Curso Asignado!', data.message, 'success');
                    mostrarCursosAsignados(promotoriaId);
                    selectCurso.value = '';
                } else {
                    Swal.fire('¡Error!', data.message, 'error');
                }
            })
            .catch(error => {
                console.error('Error al asignar curso:', error);
                Swal.fire('Error', 'No se pudo asignar el curso.', 'error');
            });
    }

    function eliminarCursoAsignado(promotoriaId, cursoId) {
        Swal.fire({
            title: '¿Estás seguro?',
            text: '¿Deseas eliminar este curso de la promotoria?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Eliminar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                fetch('../../../../controllers/eliminar_curso_asignado.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: `promotoria_id=${promotoriaId}&curso_id=${cursoId}`
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            Swal.fire('¡Eliminado!', data.message, 'success');
                            mostrarCursosAsignados(promotoriaId);
                        } else {
                            Swal.fire('¡Error!', data.message, 'error');
                        }
                    })
                    .catch(error => {
                        console.error('Error al eliminar curso:', error);
                        Swal.fire('Error', 'No se pudo eliminar el curso.',
                            'error');
                    });
            }
        });
    }

    function guardarNuevaPromotoria(empresaId, nombrePromotoria) {
        fetch('../../../../controllers/guardar_promotoria.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: `empresa_id=${empresaId}&nombre=${nombrePromotoria}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire('¡Promotoria Creada!', data.message, 'success').then(() => {
                        cargarPromotorias();
                        modalNuevaPromotoria.hide();
                        formNuevaPromotoria.reset();
                    });
                } else {
                    Swal.fire('¡Error!', data.message, 'error');
                }
            })
            .catch(error => {
                console.error('Error al guardar promotoria:', error);
                Swal.fire('Error', 'No se pudo guardar la promotoria.', 'error');
            });
    }

    // Eventos
    selectPromotoria.addEventListener('change', function() {
        const promotoriaId = this.value;
        mostrarCursosAsignados(promotoriaId);
    });

    btnAsignarCurso.addEventListener('click', function() {
        const promotoriaId = selectPromotoria.value;
        const cursoId = selectCurso.value;

        if (promotoriaId && cursoId) {
            asignarCurso(promotoriaId, cursoId);
        } else {
            Swal.fire('¡Advertencia!',
                'Por favor, seleccione una promotoria y un curso.',
                'warning');
        }
    });

    cursosAsignadosList.addEventListener('click', function(event) {
        if (event.target.classList.contains('btn-eliminar-curso')) {
            const cursoId = event.target.dataset.cursoId;
            const promotoriaId = selectPromotoria.value;
            if (promotoriaId && cursoId) {
                eliminarCursoAsignado(promotoriaId, cursoId);
            }
        }
    });

    btnGuardarPromotoria.addEventListener('click', function() {
        const nombreNuevaPromotoria = document.getElementById('nombreNuevaPromotoria').value.trim();
        const selectEmpresa = document.getElementById('selectEmpresa').value.trim();
        console.log(nombreNuevaPromotoria + ' ' + selectEmpresa);
        if (nombreNuevaPromotoria) {
            guardarNuevaPromotoria(selectEmpresa, nombreNuevaPromotoria);
        } else {
            Swal.fire('¡Advertencia!', 'Por favor, ingrese el nombre de la promotoria.',
                'warning');
        }
    });

    // Carga inicial
    cargarPromotorias();
    cargarEmpresas();
});
</script>
<?php require('../../components/FooterAdmin.php'); ?>