<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuEmpleado.php');
?>

<style>
.nav li {
    font-size: 18px;
    font-weight: 600;
}

.nav li .nav-link {
    color: var(--header);
    transition: all 0.4s ease-in-out;
    padding: 20px 32px;
    border-radius: 30px;
    line-height: 1;
}

.nav li .nav-link.active {
    position: relative;
    background-color: #3758ee;
    color: white;
}

.featured-courses-item-2 {
    border-radius: 18px;
    border: 1px solid rgba(25, 35, 53, 0.2);
    background-color: white;
    margin-top: 30px;
    position: relative;
}

.featured-courses-item-2 .courses-image {
    position: relative;
}

.featured-courses-item-2 .courses-image img {
    width: 100%;
    height: 100%;
    border-top-left-radius: 18px;
    border-top-right-radius: 18px;
}

.featured-courses-item-2 .courses-image .time {
    position: absolute;
    left: 24px;
    top: 24px;
    color: white;
    background-color: #3758ee;
    line-height: 1;
    padding: 8px 10px;
    border-radius: 6px;
}

.featured-courses-item-2 .courses-content {
    padding: 20px 24px 30px;
}

.featured-courses-item-2 .courses-content .courses-part {
    margin-bottom: 18px;
}

.featured-courses-item-2 .courses-content .courses-part .small-btn {
    font-size: 14px;
    font-weight: 600;
    padding: 8px 16px;
    border-radius: 30px;
    border: 1px solid rgba(25, 35, 53, 0.2);
    line-height: 1;
    transition: all 0.4s ease-in-out;
    text-decoration: none;
}

.courses-content h4 {
    font-size: 22px;
    font-weight: 700;
    line-height: 127%;
}

.courses-content h4 a {
    outline: none !important;
    cursor: pointer;

    transition: all 0.4s ease-in-out;
}

.featured-courses-item-2 .courses-content .courses-meta {
    display: flex;
    align-items: center;
    gap: 30px;
    margin-top: 20px;
    border-bottom: 1px solid rgba(25, 35, 53, 0.2);
    padding-bottom: 25px;
    margin-bottom: 25px;
}

.featured-courses-item-2 .courses-content .courses-info-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.featured-courses-item-2 .courses-content .courses-info-item .courses-info {
    display: flex;
    align-items: center;
    gap: 10px;
}

.featured-courses-item-2 .courses-content .courses-info-item .courses-info .info-image img {
    width: 32px;
    height: 32px;
    border-radius: 50%;
}

.courses-info-item .star i {
    color: rgb(255, 164, 27);
}
</style>
<main class="app-main">
    <!--begin::App Content Header-->
    <div class="app-content-header">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="mb-0">Bienvenido:
                        <?php echo  $_SESSION["nombre_completo"] ?></h3>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-end">
                        <li class="breadcrumb-item"><a href="#">Home</a></li>
                        <li class="breadcrumb-item active" aria-current="page">
                            Dashboard
                        </li>
                    </ol>
                </div>
            </div>
            <!--end::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content Header-->
    <!--begin::App Content-->
    <div class="app-content">
        <!--begin::Container-->
        <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
                <!--begin::Col-->
                <?php $_SESSION["promotoria"];

                $idusu = $_SESSION["usuario_id"]; ?>
                <div class="col-lg-12 col-12 col-md-12">
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title">Cursos Disponibles</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-lte-toggle="card-collapse">
                                    <i data-lte-icon="expand" class="bi bi-plus-lg"></i>
                                    <i data-lte-icon="collapse" class="bi bi-dash-lg"></i>
                                </button>
                            </div>
                            <!-- /.card-tools -->
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div id="all" class="tab-pane fade active show" role="tabpanel">
                                <div class="row">
                                    <?php
                                    $allCourses = mysqli_query($conexion, "
                            SELECT c.curso_id, c.curso_title, cat.titulo, cat.url_img 
                            FROM cursos c 
                            LEFT JOIN categoria cat ON c.categoria_id = cat.categoria_id
                        ");
                                    while ($row = mysqli_fetch_assoc($allCourses)) {
                                    ?>
                                    <div class="col-xl-3 col-lg-4 col-md-4">
                                        <div class="featured-courses-item-2">
                                            <div class="courses-image">
                                                <img src="<?= $row["url_img"] ?>" alt="img">
                                                <h6 class="time"><?= $row["titulo"] ?></h6>
                                            </div>
                                            <div class="courses-content">
                                                <div class="courses-part">
                                                    <!-- <a href="" class="small-btn">Ingresar al
                                                        Curso</a> -->
                                                    <!-- Button trigger modal -->
                                                    <button type="button" class="small-btn btn-acceder"
                                                        data-bs-toggle="modal" data-bs-target="#exampleModal"
                                                        data-idcurso="<?= $row["curso_id"] ?>"
                                                        data-namecurso="<?= $row["curso_title"] ?>"
                                                        data-iduser="<?= $idusu ?>">
                                                        Acceder a Curso
                                                    </button>
                                                </div>
                                                <h4><a href="#"><?= $row["curso_title"] ?></a>
                                                </h4>
                                                <ul class="courses-meta">
                                                    <li>
                                                        <i class="fa-solid fa-users"></i>
                                                        169 Students
                                                    </li>
                                                    <li>
                                                        <i class="fa-solid fa-book-open-reader"></i>
                                                        12 Lessons
                                                    </li>
                                                </ul>
                                                <div class="courses-info-item">
                                                    <div class="courses-info">
                                                        <div class="info-image">
                                                            <img src="https://i.pinimg.com/originals/61/02/2c/61022c12a08851a91352dc9c7b2dd934.jpg"
                                                                alt="img">
                                                        </div>
                                                        <h5>LEARN-O</h5>
                                                    </div>
                                                    <div class="star">
                                                        <i class="fa-solid fa-star"></i>
                                                        <i class="fa-solid fa-star"></i>
                                                        <i class="fa-solid fa-star"></i>
                                                        <i class="fa-solid fa-star"></i>
                                                        <i class="fa-solid fa-star color"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>


                <!--end::Col-->
            </div>
            <!--end::Row-->
            <!--begin::Row-->
        </div>
        <!--end::Container-->
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Acceder al Curso</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formaccedercurso" action="POST">
                    <input type="hidden" id="idcursoselect" name="idcursoselect">
                    <input type="hidden" id="namecursoselect" name="namecursoselect">
                    <input type="hidden" id="iduserselect" name="iduserselect">

                    <h2 class="card-title text-center mb-4 text-primary">¡Bienvenido al inicio de tu curso de
                        capacitación!</h2>
                    <br>
                    <br>
                    <p class="mb-3">
                        Nos da mucho gusto contar con tu participación en este curso, diseñado especialmente para
                        fortalecer tus conocimientos y competencias con base en <strong>[motivo de la
                            capacitación]</strong>.
                        A través de este proceso formativo, buscamos brindarte herramientas prácticas y teóricas que te
                        serán de gran utilidad en tu día a día laboral, contribuyendo a tu crecimiento profesional y al
                        fortalecimiento de nuestro equipo.
                    </p>

                    <h5 class="text-secondary mt-4 mb-2">El curso consta de dos elementos clave:</h5>
                    <ul class="list-group list-group-flush mb-4">
                        <li class="list-group-item">
                            <strong>Material audiovisual:</strong> contenido dinámico que te permitirá visualizar
                            situaciones reales o simuladas, facilitando una mejor comprensión del tema.
                        </li>
                        <li class="list-group-item">
                            <strong>Presentación teórica:</strong> diseñada para reforzar la información vista en el
                            video, con explicaciones más detalladas, ejemplos y conceptos clave que podrás revisar a tu
                            ritmo.
                        </li>
                    </ul>

                    <p class="mb-3">
                        Este formato busca adaptarse a distintos estilos de aprendizaje, permitiéndote absorber la
                        información de manera más efectiva.
                        Te recomendamos prestar atención a cada parte del curso, ya que están diseñadas de forma
                        complementaria. Al finalizar el recorrido, contarás con una base más sólida para aplicar lo
                        aprendido en tus actividades laborales.
                    </p>

                    <p class="mb-3">
                        Queremos recordarte que este espacio de aprendizaje es tuyo: tómate el tiempo necesario, repasa
                        el contenido cuantas veces lo necesites y no dudes en tomar notas o marcar puntos importantes.
                        Al final del curso, tendrás la oportunidad de demostrar tu comprensión a través de una breve
                        evaluación.
                    </p>

                    <p class="fw-semibold text-success">
                        Tu disposición para capacitarte marca la diferencia. ¡Gracias por asumir este compromiso con
                        responsabilidad y entusiasmo!
                    </p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary">Ingresar</button>
            </div>
            </form>
        </div>
    </div>
</div>



<script>
//script para mostrar los datos en el modal de editar
// document.addEventListener("DOMContentLoaded", function() {
//     // Detectamos clics en cualquier parte del documento
//     document.addEventListener("click", function(event) {
//         // Verificamos si el clic fue en un botón de edición
//         if (event.target.closest(".btn-acceder")) {
//             let boton = event.target.closest(".btn-acceder");

//             // Obtener referencias a los campos del modal
//             let modal = document.getElementById("exampleModal");

//             // Llenar los campos con los atributos del botón

//             modal.querySelector("#idcursoselect").value = boton.getAttribute(
//                 "data-idcurso");
//             modal.querySelector("#namecursoselect").value = boton.getAttribute("data-namecurso");
//             // Mostrar el modal
//             let modalInstance = new bootstrap.Modal(modal);
//             modalInstance.show();
//         }
//     });
// });


// Script para mostrar los datos en el modal de editar
document.addEventListener("DOMContentLoaded", function() {
    // Detectamos clics en cualquier parte del documento
    document.addEventListener("click", function(event) {
        // Verificamos si el clic fue en un botón de edición
        if (event.target.closest(".btn-acceder")) {
            let boton = event.target.closest(".btn-acceder");

            // Obtener referencia al modal
            let modal = document.getElementById("exampleModal");

            // Llenar los campos con los atributos del botón
            modal.querySelector("#idcursoselect").value = boton.getAttribute("data-idcurso");
            modal.querySelector("#namecursoselect").value = boton.getAttribute("data-namecurso");
            modal.querySelector("#iduserselect").value = boton.getAttribute("data-iduser");


            // Obtener o crear la instancia del modal
            let modalInstance = bootstrap.Modal.getInstance(modal);
            if (!modalInstance) {
                modalInstance = new bootstrap.Modal(modal);
            }

            // Mostrar el modal
            modalInstance.show();
        }
    });

    // Limpiar los campos del modal al cerrarse (opcional pero recomendado)
    const modal = document.getElementById("exampleModal");
    modal.addEventListener('hidden.bs.modal', function() {
        modal.querySelector("#idcursoselect").value = '';
        modal.querySelector("#namecursoselect").value = '';
    });
});





const formaccedercurso = document.getElementById("formaccedercurso");

// formaccedercurso.addEventListener("submit", function(e) {
//     e.preventDefault(); // Evitar el envío normal del formulario

//     Swal.fire({
//         title: "¿Estás seguro?",
//         text: "Vas a acceder a este curso.",
//         icon: "question",
//         showCancelButton: true,
//         confirmButtonText: "Sí, acceder",
//         cancelButtonText: "Cancelar"
//     }).then((result) => {
//         if (result.isConfirmed) {
//             const formData = new FormData(formaccedercurso);

//             fetch("../../../../controllers/ingreso-curso-usuario.php", {
//                     method: "POST",
//                     body: formData
//                 })
//                 .then(response => response.json())
//                 .then(data => {
//                     if (typeof data !== "object" || !data.status) {
//                         throw new Error("La respuesta del servidor no es válida.");
//                     }

//                     if (data.status === "success") {
//                         Swal.fire({
//                             icon: "success",
//                             title: "Acceso concedido",
//                             text: data.message,
//                             timer: 1500,
//                             showConfirmButton: false
//                         }).then(() => {
//                             // Redirigir al curso con su ID
//                             window.location.href =
//                                 `../introduccion-curso/curso.php?cursoseleccionado=${data.curso_id}`;
//                         });
//                     } else {
//                         Swal.fire({
//                             icon: "error",
//                             title: "Error",
//                             text: data.message,
//                         });
//                     }
//                 })
//                 .catch(error => {
//                     console.error("Error en el acceso:", error);
//                     Swal.fire({
//                         icon: "error",
//                         title: "Error de conexión",
//                         text: "No se pudo acceder al curso. Intenta más tarde.",
//                     });
//                 });
//         }
//     });
// });

formaccedercurso.addEventListener("submit", function(e) {
    e.preventDefault(); // Evitar el envío normal del formulario

    Swal.fire({
        title: "¿Estás seguro?",
        text: "Vas a acceder a este curso.",
        icon: "question",
        showCancelButton: true,
        confirmButtonText: "Sí, acceder",
        cancelButtonText: "Cancelar"
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData(formaccedercurso);

            fetch("../../../../controllers/ingreso-curso-usuario.php", {
                    method: "POST",
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (typeof data !== "object" || !data.status) {
                        throw new Error("La respuesta del servidor no es válida.");
                    }

                    let redirectUrl = '';

                    if (data.status === "success") {
                        redirectUrl =
                            `../introduccion-curso/curso.php?cursoseleccionado=${data.curso_id}`;
                        Swal.fire({
                            icon: "success",
                            title: "Acceso concedido",
                            text: data.message,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = redirectUrl;
                        });
                    } else if (data.status === "info") {
                        redirectUrl =
                            `../introduccion-curso/inicio-curso.php?cursoenproceso=${data.curso_id}`;
                        if (data.usuario_curso_id) {
                            redirectUrl += `&usuario_curso_id=${data.usuario_curso_id}`;
                        }
                        Swal.fire({
                            icon: "info",
                            title: "Ya estás en el curso",
                            text: data.message,
                            timer: 1500,
                            showConfirmButton: false
                        }).then(() => {
                            window.location.href = redirectUrl;
                        });
                    } else {
                        Swal.fire({
                            icon: "error",
                            title: "Error",
                            text: data.message,
                        });
                    }
                })
                .catch(error => {
                    console.error("Error en el acceso:", error);
                    Swal.fire({
                        icon: "error",
                        title: "Error de conexión",
                        text: "No se pudo acceder al curso. Intenta más tarde.",
                    });
                });
        }
    });
});
</script>
<?php require('../../components/FooterAdmin.php'); ?>