<?php
require('../../components/HeaderAdmin.php');
require('../../components/menuEmpleado.php');
?>
<main class="app-main">
  <!--begin::App Content Header-->
  <div class="app-content-header">
    <!--begin::Container-->
    <div class="container-fluid">
      <!--begin::Row-->
      <div class="row">
        <div class="col-sm-6">
          <h3 class="mb-0">
            <?php $_SESSION["nombre_completo"];
            $idusu = $_SESSION["usuario_id"]; ?></h3>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-end">
            <li class="breadcrumb-item"><a href="#">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">
              Dashboard
            </li>
          </ol>
        </div>
      </div>
      <!--end::Row-->
    </div>
    <!--end::Container-->
  </div>
  <!--end::App Content Header-->
  <!--begin::App Content-->
  <div class="app-content">
    <!--begin::Container-->
    <!-- Content wrapper -->
    <div class="content-wrapper">
      <!-- Content -->
      <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
          <div class="col-md-12">
            <div class="nav-align-top mb-3">
              <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-md-0 gap-2" id="accountTabs">
                <li class="nav-item">
                  <a class="nav-link active" href="#" data-target="#formAccountViewData"><i
                      class="icon-base bx bx-user icon-sm me-1_5"></i> Perfil</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link" href="#" data-target="#formAccountcontra"><i
                      class="icon-base bx bx-bell icon-sm me-1_5"></i> Seguridad</a>
                </li>
              </ul>
            </div>
            <div class="card mb-6">
              <!-- Account -->
              <div class="card-body">
                <div class="d-flex align-items-start align-items-sm-center gap-6 pb-4 border-bottom">
                  <img src="https://cdn-icons-png.flaticon.com/512/4792/4792929.png" alt="user-avatar"
                    class="rounded-circle object-fit-cover border border-2 border-light"
                    style="width: 120px; height: 120px;" id="uploadedAvatar">
                  <div class="button-wrapper">
                    <label for="upload" class="btn btn-primary me-3 mb-4" tabindex="0">
                      <span class="d-none d-sm-block">Subir Foto</span>
                      <i class="icon-base bx bx-upload d-block d-sm-none"></i>
                      <input type="file" id="upload" class="account-file-input" hidden
                        accept="image/png, image/jpeg" />
                    </label>
                    <button type="button"
                      class="btn btn-outline-secondary account-image-reset mb-4" disabled>
                      <i class="icon-base bx bx-reset d-block d-sm-none"></i>
                      <span class="d-none d-sm-block">Reset</span>
                    </button>

                    <div>JPG, PNG. Max size of 800K</div>
                  </div>
                </div>
              </div>
              <div class="card-body pt-4">
                <?php
                $sql = "SELECT 
              u.usuario_id,
              u.nombre_completo,
              u.rfc,
              u.curp,
              u.email,
              u.estado_lugar,
              u.promotoria_id,
              p.nombre_promotoria,
              u.status,
              u.fecha_ingreso
            FROM usuarios u
            LEFT JOIN promotorias p ON p.promotoria_id = u.promotoria_id
            WHERE u.usuario_id = ?";

                $stmt = $conexion->prepare($sql);
                $stmt->bind_param("i", $idusu);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($row = $result->fetch_assoc()) {

                ?>
                  <form id="formAccountViewData" method="POST" onsubmit="return false">
                    <div class="row g-6">
                      <div class="col-md-6 mt-3">
                        <label for="firstName" class="form-label">NOMBRE COMPLETO</label>
                        <input type="text" class="form-control" name="nombreedit" id="edit_nombre"
                          value="<?= htmlspecialchars($row['nombre_completo']) ?>">
                      </div>
                      <div class="col-md-6 mt-3">
                        <label for="email" class="form-label">E-MAIL</label>
                        <input type="email" class="form-control" name="email" id="edit_email"
                          value="<?= htmlspecialchars($row['email']) ?>">
                      </div>
                      <div class="col-md-6 mt-3">
                        <label for="organization" class="form-label">PROMOTORIA</label>
                        <input type="text" class="form-control" name="promotoria" id="promotoria"
                          value="<?= htmlspecialchars($row['nombre_promotoria']) ?>">
                      </div>
                      <div class="col-md-6 mt-3">
                        <label for="organization" class="form-label">RFC</label>
                        <input type="text" class="form-control" name="rfcedit" id="edit_rfc"
                          value="<?= htmlspecialchars($row['rfc']) ?>">
                      </div>
                      <div class="col-md-6 mt-3">
                        <label for="organization" class="form-label">CURP</label>
                        <input type="text" class="form-control" name="curp" id="edit_curp"
                          value="<?= htmlspecialchars($row['curp']) ?>">
                      </div>
                      <div class="col-md-6 mt-3">
                        <label for="edit_estatus" class="form-label">ESTATUS</label>
                        <select class="form-select" name="estatus" id="edit_estatus" disabled>
                          <option value="INACTIVO"
                            <?= $row['status'] === 'INACTIVO' ? 'selected' : '' ?>>Inactivo
                          </option>
                          <option value="ACTIVO"
                            <?= $row['status'] === 'ACTIVO' ? 'selected' : '' ?>>Activo</option>
                        </select>
                      </div>
                      <div class="col-md-6 mt-3">
                        <label for="edit_estado" class="form-label">ESTADO</label>
                        <?php
                        $estadoSeleccionado = $row['estado_lugar'] ?? '';
                        $estados = [
                          'AGS' => 'Aguascalientes',
                          'BC' => 'Baja California',
                          'BCS' => 'Baja California Sur',
                          'CAMP' => 'Campeche',
                          'CHIS' => 'Chiapas',
                          'CHIH' => 'Chihuahua',
                          'COAH' => 'Coahuila',
                          'COL' => 'Colima',
                          'CDMX' => 'Ciudad de México',
                          'DGO' => 'Durango',
                          'GTO' => 'Guanajuato',
                          'GRO' => 'Guerrero',
                          'HGO' => 'Hidalgo',
                          'JAL' => 'Jalisco',
                          'EDOMEX' => 'Estado de México',
                          'MICH' => 'Michoacán',
                          'MOR' => 'Morelos',
                          'NAY' => 'Nayarit',
                          'N.L' => 'Nuevo León',
                          'OAX' => 'Oaxaca',
                          'PUE' => 'Puebla',
                          'QRO' => 'Querétaro',
                          'QROO' => 'Quintana Roo',
                          'SLP' => 'San Luis Potosí',
                          'SIN' => 'Sinaloa',
                          'SON' => 'Sonora',
                          'TAB' => 'Tabasco',
                          'TAMPS' => 'Tamaulipas',
                          'TLAX' => 'Tlaxcala',
                          'VER' => 'Veracruz',
                          'YUC' => 'Yucatán',
                          'ZAC' => 'Zacatecas'
                        ];
                        ?>
                        <select class="form-select" id="edit_estado" name="estado" disabled>
                          <option value="" disabled
                            <?= $estadoSeleccionado === '' ? 'selected' : '' ?>>Seleccione un
                            estado</option>
                          <?php foreach ($estados as $clave => $nombre): ?>
                            <option value="<?= $clave ?>"
                              <?= $estadoSeleccionado === $clave ? 'selected' : '' ?>>
                              <?= $nombre ?>
                            </option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-6 mt-3">
                      <label for="edit_fecha_ingreso" class="form-label">FECHA INGRESO</label>
                      <input type="date" class="form-control" name="fecha_ingreso"
                        id="edit_fecha_ingreso" value="<?= $row['fecha_ingreso'] ?>" disabled>
                    </div>
                  <?php } ?>
                  </form>
                  <form id="formAccountcontra" method="GET" onsubmit="return false"
                    style="display: none;">
                    <div class="row mt-3">
                      <div class="mb-6 col-md-6 form-password-toggle form-control-validation">
                        <label class="form-label" for="currentPassword">Ingrese Contraseña
                          Actual</label>
                        <div class="input-group input-group-merge">
                          <input class="form-control" type="password" name="currentPassword"
                            id="actualPassword"
                            placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" />
                          <span class="input-group-text cursor-pointer"><i
                              class="icon-base bx bx-hide"></i></span>
                        </div>
                      </div>
                    </div>
                    <div class="row mt-3">
                      <div class="mb-6 col-md-6 form-password-toggle form-control-validation">
                        <label class="form-label" for="newPassword">Nueva Contraseña</label>
                        <div class="input-group input-group-merge">
                          <input class="form-control" type="password" id="newPassword"
                            name="newPassword"
                            placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" />
                          <span class="input-group-text cursor-pointer"><i
                              class="icon-base bx bx-hide"></i></span>
                        </div>
                      </div>

                      <div class="mb-6 col-md-6 form-password-toggle form-control-validation">
                        <label class="form-label" for="confirmPassword">Confirmar Nueva
                          Contraseña</label>
                        <div class="input-group input-group-merge">
                          <input class="form-control" type="password" name="confirmPassword"
                            id="confirmPassword"
                            placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;" />
                          <span class="input-group-text cursor-pointer"><i
                              class="icon-base bx bx-hide"></i></span>
                        </div>
                      </div>
                    </div>
                    <div class="mt-3">
                      <button type="submit" class="btn btn-primary me-3">Actualizar
                        Contraseña</button>

                    </div>
                  </form>
              </div>
              <!-- /Account -->
            </div>

          </div>
        </div>
      </div>
      <!-- / Content -->
      <!--end::Container-->
    </div>
    <!--end::App Content-->
</main>
<!--end::App Main-->
<!--begin::Footer-->

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const statusSelect = document.getElementById('edit_estatus');

    // Función para actualizar el color
    function updateSelectColor() {
      if (statusSelect.value === 'ACTIVO') {
        statusSelect.classList.remove('bg-danger', 'text-white');
        statusSelect.classList.add('bg-success', 'text-white');
      } else {
        statusSelect.classList.remove('bg-success', 'text-white');
        statusSelect.classList.add('bg-danger', 'text-white');
      }
    }

    // Aplicar al cargar la página
    updateSelectColor();

    // Escuchar cambios
    statusSelect.addEventListener('change', updateSelectColor);
  });
  document.querySelectorAll('#accountTabs .nav-link').forEach(link => {
    link.addEventListener('click', function(e) {
      e.preventDefault();

      // Activar tab visualmente
      document.querySelectorAll('#accountTabs .nav-link').forEach(l => l.classList.remove('active'));
      this.classList.add('active');

      // Mostrar el formulario correspondiente
      const target = this.getAttribute('data-target');
      document.querySelectorAll('.card-body form').forEach(form => {
        form.style.display = form.id === target.substring(1) ? 'block' : 'none';
      });
    });
  });
</script>


<?php require('../../components/FooterAdmin.php'); ?>