<?php
session_start();

// Permitir solicitudes CORS si es necesario
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// Verificar si la solicitud es AJAX (opcional)
$isAjax = isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';

try {
    // Validar método de solicitud
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Obtener datos del cuerpo de la petición
        $input = json_decode(file_get_contents('php://input'), true);

        // Validar acción (ahora más flexible)
        if (isset($input['accion']) || $isAjax) {
            // Eliminar variables de sesión del curso
            unset($_SESSION['curso_en_progreso']);
            unset($_SESSION['curso_actual']);

            // Opcional: Registrar en BD
            // require_once '../../config/database.php';
            // $stmt = $pdo->prepare("UPDATE usuarios_cursos SET estado = 'completado' 
            //                      WHERE usuario_id = ? AND curso_id = ?");
            // $stmt->execute([$_SESSION['usuario_id'], $_SESSION['curso_id']]);

            if ($isAjax) {
                echo json_encode(['success' => true]);
                exit();
            } else {
                header("Location: ../panel-curso/panel-curso.php?curso_finalizado=1");
                exit();
            }
        }
    }

    // Si no es POST o no tiene acción válida, redirigir
    if ($isAjax) {
        echo json_encode(['success' => false, 'error' => 'Método no permitido']);
    } else {
        header("Location: ../panel-curso/panel-curso.php?error=accion_invalida");
    }
    exit();
} catch (Exception $e) {
    if ($isAjax) {
        echo json_encode(['success' => false, 'error' => $e->getMessage()]);
    } else {
        header("Location: ../panel-curso/panel-curso.php?error=server_error");
    }
    exit();
}