<?php
session_start();
require('../../../../config/config.php');
$cursoselecd = isset($_GET['cursoseleccionado']) ? (int) $_GET['cursoseleccionado'] : null;

$usuario_id = $_SESSION["usuario_id"];

if (!isset($_SESSION["usuario_id"])) {
    header("Location: ../../../../login/login.php");
    exit();
}

?>


</h1>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Bienvenido al Curso - Plataforma de Cursos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
    body {
        background-color: #f0f4f8;
        font-family: 'Poppins', sans-serif;
        color: #333;
        margin: 0;
        padding: 0;
    }

    .container {
        max-width: 1200px;
        margin: auto;
    }

    .course-card {
        background-color: #fff;
        border-radius: 1.5rem;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
        overflow: hidden;
        /* Para bordes redondeados con la imagen */
    }

    .course-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.15);
    }

    .card-header {
        background: linear-gradient(135deg, #43a085, #2c3e50);
        color: white;
        padding: 2rem;
        text-align: center;
        border-bottom: none;
        /* border-top-left-radius: 1.5rem;
            border-top-right-radius: 1.5rem; */
    }

    .card-body {
        padding: 2rem;
    }

    .card-title {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
    }

    .lead {
        font-size: 1.1rem;
        color: #555;
        margin-bottom: 2rem;
        color: white;
    }

    hr {
        border-top: 1px solid #eee;
        margin: 2rem 0;
    }

    .user-data h5,
    .progress-data h5,
    .last-session h5 {
        font-size: 1.2rem;
        font-weight: 600;
        color: #444;
        margin-bottom: 1rem;
    }

    .user-data p,
    .progress-data p,
    .last-session p {
        font-size: 1rem;
        color: #666;
        margin-bottom: 0.5rem;
    }

    .progress {
        height: 1rem;
        border-radius: 0.5rem;
        background-color: #e9ecef;
        margin-bottom: 1rem;
    }

    .progress-bar {
        background-color: #43a085;
    }

    .btn-start {
        background-color: #43a085;
        color: white;
        font-size: 1.2rem;
        padding: 1rem 2rem;
        border: none;
        border-radius: 0.5rem;
        cursor: pointer;
        transition: background-color 0.3s ease;
    }

    .btn-start:hover {
        background-color: #36806a;
    }

    .btn-outline-secondary {
        border-color: #ccc;
        color: #6c757d;
        transition: border-color 0.3s ease, color 0.3s ease;
    }

    .btn-outline-secondary:hover {
        border-color: #aaa;
        color: #495057;
    }

    .tutorial-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        display: none;
        justify-content: center;
        align-items: center;
        z-index: 1000;
    }

    .tutorial-card {
        background-color: white;
        padding: 2rem;
        border-radius: 1rem;
        max-width: 600px;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
    }

    .tutorial-card h2 {
        font-size: 1.8rem;
        margin-bottom: 1.5rem;
    }

    .tutorial-card ol {
        margin-bottom: 1.5rem;
    }

    .tutorial-card li {
        font-size: 1rem;
        line-height: 1.6;
        margin-bottom: 0.5rem;
    }

    /* Image styles */
    .course-image {
        width: 100%;
        height: 200px;
        object-fit: cover;
        border-top-left-radius: 1.5rem;
        border-top-right-radius: 1.5rem;
    }
    </style>
</head>

<body>
    <div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <?php
            if (isset($cursoselecd) && is_numeric($cursoselecd)) {
                // -------------------- CONSULTA DE DATOS DEL CURSO --------------------
                $stmt1 = mysqli_prepare($conexion, "SELECT c.curso_id, c.curso_title, c.curso_description, c.fecha_inicio, c.fecha_fin, c.created_at, c.categoria_id, cat.titulo, cat.url_img, dc.objetivos_aprendizaje, dc.audiencia_objetivo, dc.requisitos_previos, dc.duracion, dc.modalidad, dc.evaluacion, dc.instructor FROM cursos c LEFT JOIN detalles_curso dc ON dc.curso_id = c.curso_id LEFT JOIN categoria cat ON cat.categoria_id = c.categoria_id WHERE c.curso_id = ?");
                mysqli_stmt_bind_param($stmt1, "i", $cursoselecd);
                mysqli_stmt_execute($stmt1);
                $result1 = mysqli_stmt_get_result($stmt1);
                $curso = mysqli_fetch_assoc($result1);
                mysqli_stmt_close($stmt1);

                if ($curso) {
            ?>
            <div class="card course-card">
                <img src="https://apliint.com/wp-content/uploads/2020/11/Principales-tipos-de-desarrolladores.jpg" alt="Course Image" class="course-image">
                <div class="card-header">
                    <h1 class="card-title">Bienvenido a <?= htmlspecialchars($curso["curso_title"]) ?></h1>
                    <p class="lead"><?= html_entity_decode($curso["curso_description"]) ?></p>
                </div>
                <div class="card-body">
                    <hr />
                    <div class="user-data">
                        <h5><i class="fas fa-user"></i> Datos del Usuario</h5>
                        <p><strong>Nombre:</strong> <?= $_SESSION["nombre_completo"]; ?></p>
                        <p><strong>Email:</strong> <?= $_SESSION["email"]; ?></p>
                    </div>

                    <hr />
                    <div class="progress-data" style="display:none">
                        <h5><i class="fas fa-chart-line"></i> Progreso del Curso</h5>
                        <div class="progress">
                            <div class="progress-bar" role="progressbar" style="width: 0%;" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100">0%</div>
                        </div>
                        <p>Has completado el 0% del curso.</p>
                    </div>

                    <hr />
                    <div class="last-session mb-5"  style="display:none">
                        <h5><i class="fas fa-clock"></i> Última Sesión</h5>
                        <p>Último acceso: 15 de Octubre, 2023</p>
                    </div>

                    <div class="course-curriculum-items">
                        <h5><i class="fa fa-server"></i> Contenido del Curso</h5>
                        <div class="courses-faq-items">
                            <div class="accordion" id="accordionExample">
                               <?php
$temario_organizado = [];

$stmt = mysqli_prepare($conexion, "SELECT 
    tt.ID_Titulo,
    tt.nom_titulo_temario,
    cot.id_Contenido,
    cot.nombre_contenido,
    cot.descripcion_contenido
FROM titulos_temarios tt
LEFT JOIN contenidos_titulos_temarios cot ON cot.ID_Titulo = tt.ID_Titulo
WHERE tt.curso_id = ?
ORDER BY tt.Orden, cot.Orden");

mysqli_stmt_bind_param($stmt, "i", $cursoselecd);
mysqli_stmt_execute($stmt);
$result2 = mysqli_stmt_get_result($stmt);

while ($row2 = mysqli_fetch_assoc($result2)) {
    $titulo = $row2['nom_titulo_temario'];

    if (!isset($temario_organizado[$titulo])) {
        $temario_organizado[$titulo] = [];
    }

    // Obtener materiales del contenido actual
    $materiales_stmt = mysqli_prepare($conexion, "SELECT tipo_material, ruta_archivo FROM materiales_contenido WHERE id_Contenido = ?");
    mysqli_stmt_bind_param($materiales_stmt, "i", $row2['id_Contenido']);
    mysqli_stmt_execute($materiales_stmt);
    $materiales_result = mysqli_stmt_get_result($materiales_stmt);

    $materiales = [];
    while ($mat = mysqli_fetch_assoc($materiales_result)) {
        $materiales[] = $mat;
    }
    mysqli_stmt_close($materiales_stmt);

    $temario_organizado[$titulo][] = [
        'nombre' => $row2['nombre_contenido'],
        'materiales' => $materiales
    ];
}
mysqli_stmt_close($stmt);
?>
<?php foreach ($temario_organizado as $titulo => $contenidos): ?>
    <div class="mb-4">
        <h5 class="text-primary"><?php echo htmlspecialchars($titulo); ?></h5>
        <ul class="list-group">
            <?php foreach ($contenidos as $contenido): ?>
                <li class="list-group-item">
                    <strong><?php echo htmlspecialchars($contenido['nombre']); ?></strong>
                    <?php if (!empty($contenido['materiales'])): ?>
                        <ul class="mt-2">
                            <?php foreach ($contenido['materiales'] as $material): ?>
                                <?php
                                    $icon_class = match ($material['tipo_material']) {
                                        'Video' => 'fa-brands fa-youtube text-danger',
                                        'PDF' => 'fa-solid fa-file-pdf text-danger',
                                        'Word' => 'fa-solid fa-file-word text-primary',
                                        default => 'fa-solid fa-file',
                                    };
                                ?>
                                <li>
                                    <i class="<?php echo $icon_class; ?>"></i>
                                    <a href="../../../../controllers/<?php echo htmlspecialchars($material['ruta_archivo']); ?>" target="_blank">
                                        <?php echo htmlspecialchars($material['tipo_material']); ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        <p class="text-muted small">Sin materiales.</p>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <hr />
                    <div class="text-center">
                        <a href="inicio-curso.php?cursoenproceso=<?= $curso['curso_id'] ?>" class="btn btn-start">
                            <i class="fas fa-play"></i> Iniciar Curso
                        </a>
                        <button id="tutorialButton" class="btn btn-outline-secondary mt-3" disabled>
                            <i class="fas fa-question-circle"></i> Tutorial del Curso
                        </button>
                    </div>
                </div>
            </div>
            <?php
                } else {
                    echo "<div class='alert alert-warning'>No se encontró el curso.</div>";
                }
            } else {
                echo "<div class='alert alert-danger'>Curso inválido o no especificado.</div>";
            }
            ?>
        </div>
    </div>
</div>

    

    <div id=" tutorialOverlay" class="tutorial-overlay">
        <div class="tutorial-card">
            <h2>Tutorial del Curso de Desarrollo Web</h2>
            <p>¡Bienvenido! Aquí te explicamos cómo navegar por el curso:</p>
            <ol>
                <li><strong>Iniciar Curso:</strong> Haz clic en el botón "Iniciar Curso" para
                    comenzar.</li>
                <li><strong>Progreso:</strong> Revisa tu progreso en la barra de progreso.</li>
                <li><strong>Lecciones:</strong> Cada bloque contiene lecciones interactivas.
                </li>
                <li><strong>Recursos:</strong> Descarga materiales adicionales en cada lección.
                </li>
                <li><strong>Soporte:</strong> Contacta a soporte si tienes dudas.</li>
            </ol>
            <div class="text-center">
                <button id="closeTutorial" class="btn btn-secondary">Cerrar Tutorial</button>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js">
    </script>
    <script>
    document.getElementById('tutorialButton').addEventListener('click', function() {
        document.getElementById('tutorialOverlay').style.display = 'flex';
    });

    document.getElementById('closeTutorial').addEventListener('click', function() {
        document.getElementById('tutorialOverlay').style.display = 'none';
    });
    </script>
</body>

</html>