<?php
session_start();
$cursoiniciado = isset($_GET['cursoenproceso']) ? (int) $_GET['cursoenproceso'] : null;
if (!isset($_SESSION["usuario_id"])) {
    header("Location: ../../../../login/login.php");
    exit();
}

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Bloque 1 - Fundamentos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <style>
        .progress {
            height: 25px;
        }

        .tema-completado {
            text-decoration: line-through;
            color: green;
        }

        .video-container {
            position: relative;
            padding-bottom: 56.25%;
            height: 0;
            overflow: hidden;
        }

        .video-container iframe {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }

        .fade.show {
            opacity: 1 !important;
        }
    </style>
</head>


<body>
    <div class="container py-4">

    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        const cursoID = <?php echo json_encode($cursoiniciado); ?>;

        // Contenedor donde se agregarán los bloques
        const container = document.querySelector(".container");

        // Variables globales para controlar el estado
        let todosTemasCompletados = false;
        let cuestionarioMostrado = false;
        let preguntasGlobales = [];

        // Función para generar un bloque de tema (actualizada para nueva estructura)
        // function generarBloque(tema, temaIndex) {
        //     const bloqueDiv = document.createElement("div");
        //     bloqueDiv.className = "tema-container mb-5 p-4 border rounded";

        //     bloqueDiv.innerHTML = `
        //     <h2 class="mb-3">${tema.titulo}</h2>
        //     <div class="mb-3">
        //         <div class="progress">
        //             <div id="progress-bar-${temaIndex}" class="progress-bar bg-success" style="width: 0%">0%</div>
        //         </div>
        //     </div>
        //     <ul class="list-group mb-4" id="lista-temas-${temaIndex}"></ul>
        //     <div class="text-end">
        //         <button class="btn btn-primary" id="siguiente-tema-${temaIndex}">Siguiente Tema</button>
        //     </div>
        //     <!-- Reproductor de materiales -->
        //     <div id="reproductor-container-${temaIndex}" class="mt-4 border p-3 rounded" style="display: none;">
        //         <div id="reproductor-${temaIndex}" class="mb-3"></div>
        //         <div id="controles-material-${temaIndex}" style="display: none;">
        //             <button id="siguiente-material-${temaIndex}" class="btn btn-sm btn-outline-primary">Siguiente Material</button>
        //             <span id="contador-material-${temaIndex}" class="ms-2 text-muted"></span>
        //         </div>
        //     </div>
        // `;

        //     container.appendChild(bloqueDiv);

        //     const listaTemas = bloqueDiv.querySelector(`#lista-temas-${temaIndex}`);
        //     const progressBar = bloqueDiv.querySelector(`#progress-bar-${temaIndex}`);
        //     const siguienteTema = bloqueDiv.querySelector(`#siguiente-tema-${temaIndex}`);
        //     const reproductorContainer = bloqueDiv.querySelector(`#reproductor-container-${temaIndex}`);
        //     const reproductor = bloqueDiv.querySelector(`#reproductor-${temaIndex}`);
        //     const controlesMaterial = bloqueDiv.querySelector(`#controles-material-${temaIndex}`);
        //     const siguienteMaterial = bloqueDiv.querySelector(`#siguiente-material-${temaIndex}`);
        //     const contadorMaterial = bloqueDiv.querySelector(`#contador-material-${temaIndex}`);

        //     // Variables de estado
        //     let temaActual = 0;
        //     let materialActual = 0;
        //     let materialesActuales = [];

        //     // Mostrar los subtemas (contenidos) - actualizado para nueva estructura
        //     if (tema.contenidos && tema.contenidos.length > 0) {
        //         tema.contenidos.forEach((contenido, index) => {
        //             const li = document.createElement("li");
        //             li.className = "list-group-item d-flex justify-content-between align-items-center";
        //             li.innerHTML = `
        //             ${contenido.nombre}
        //             <span class="badge bg-secondary" id="check-${temaIndex}-${index}">⏳</span>
        //         `;
        //             listaTemas.appendChild(li);
        //         });
        //     } else {
        //         listaTemas.innerHTML = '<li class="list-group-item">No hay subtemas disponibles</li>';
        //     }

        //     siguienteTema.addEventListener("click", () => {
        //         if (temaActual < (tema.contenidos?.length || 0)) {
        //             // Marcar tema como completado
        //             const check = document.getElementById(`check-${temaIndex}-${temaActual}`);
        //             if (check) {
        //                 check.innerText = "✅";
        //                 check.classList.replace("bg-secondary", "bg-success");
        //             }

        //             // Cargar materiales del tema actual
        //             const contenidoActual = tema.contenidos[temaActual];
        //             if (contenidoActual?.materiales && contenidoActual.materiales.length > 0) {
        //                 materialesActuales = contenidoActual.materiales
        //                     .filter(material => ['video', 'pdf'].includes(material.tipo.toLowerCase()))
        //                     .map(material => ({
        //                         tipo: material.tipo.toLowerCase(),
        //                         ruta: material.ruta
        //                     }));

        //                 materialActual = 0;
        //                 if (materialesActuales.length > 0) {
        //                     mostrarMaterial(temaIndex, materialActual);
        //                     reproductorContainer.style.display = "block";
        //                     controlesMaterial.style.display = materialesActuales.length > 1 ? "flex" : "none";
        //                     actualizarContadorMaterial();
        //                 } else {
        //                     reproductorContainer.style.display = "none";
        //                 }
        //             }

        //             temaActual++;

        //             // Recalcular el progreso basado en los temas completos
        //             calcularProgresoPorTemas();

        //             // Verificar si todos los temas están completos para mostrar el cuestionario
        //             verificarTodosTemasCompletados();
        //         }
        //     })

        //     function calcularProgresoPorTemas() {
        //         const todosTemas = document.querySelectorAll('.tema-container');
        //         let temasCompletos = 0;

        //         todosTemas.forEach((tema) => {
        //             const checks = tema.querySelectorAll('.list-group-item .badge.bg-success');
        //             const totalChecks = tema.querySelectorAll('.list-group-item .badge').length;

        //             if (checks.length === totalChecks && totalChecks > 0) {
        //                 temasCompletos++;
        //             }
        //         });

        //         const progreso = (temasCompletos / todosTemas.length) * 100;

        //         progressBar.style.width = `${progreso}%`;
        //         progressBar.innerText = `${Math.floor(progreso)}%`;

        //         // Enviar el progreso al servidor para guardar en la base de datos
        //         fetch('../../../../controllers/actualizar-progreso-curso.php', {
        //                 method: 'POST',
        //                 headers: {
        //                     'Content-Type': 'application/x-www-form-urlencoded',
        //                 },
        //                 body: `curso_id=${cursoID}&progreso=${Math.floor(progreso)}`
        //             })
        //             .then(response => response.json())
        //             .then(data => {
        //                 if (data.status === 'error') {
        //                     console.error('Error al guardar el progreso:', data.message);
        //                 }
        //             })
        //             .catch(error => {
        //                 console.error('Error de conexión al guardar el progreso:', error);
        //             });
        //     }

        //     // Lógica del botón "Siguiente Material"
        //     siguienteMaterial.addEventListener("click", () => {
        //         materialActual++;
        //         if (materialActual < materialesActuales.length) {
        //             mostrarMaterial(temaIndex, materialActual);
        //             actualizarContadorMaterial();
        //         } else {
        //             reproductorContainer.style.display = "none";
        //         }
        //     });

        //     // Función para mostrar material específico (actualizada para nueva estructura)
        //     function mostrarMaterial(temaIndex, materialIndex) {
        //         const material = materialesActuales[materialIndex];
        //         reproductor.innerHTML = '';

        //         // Normalización del tipo de material
        //         const tipoMaterial = String(material.tipo).toLowerCase().trim();
        //         let rutaMaterial = String(material.ruta).trim();

        //         // Limpieza de la ruta
        //         rutaMaterial = rutaMaterial
        //             .replace(/([^:]\/)\/+/g, '$1')
        //             .replace(/^\/+/, '')
        //             .replace(/\/+$/, '');

        //         // Construir ruta completa
        //         const rutaCompleta = rutaMaterial.startsWith('http') || rutaMaterial.startsWith('/') ?
        //             rutaMaterial :
        //             `../../../../controllers/${rutaMaterial}`;

        //         if (tipoMaterial === 'video') {
        //             reproductor.innerHTML = `
        //             <div class="ratio ratio-16x9">
        //                 <video controls class="w-100" style="max-height: 500px;">
        //                     <source src="${rutaCompleta}" type="video/mp4">
        //                 </video>
        //             </div>
        //             <div class="mt-2 text-center">
        //                 <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-secondary">
        //                     Abrir video en nueva pestaña
        //                 </a>
        //             </div>
        //         `;

        //             // Intento de reproducción automática
        //             const videoElement = reproductor.querySelector('video');
        //             if (videoElement) {
        //                 videoElement.play().catch(error => {
        //                     console.log('Reproducción automática no permitida:', error);
        //                 });
        //             }
        //         } else if (tipoMaterial === 'pdf') {
        //             reproductor.innerHTML = `
        //             <div class="ratio ratio-16x9">
        //                 <iframe src="${rutaCompleta}#view=fitH&toolbar=0&navpanes=0" 
        //                         class="w-100" 
        //                         style="border: none;"
        //                         allowfullscreen>
        //                 </iframe>
        //             </div>
        //             <div class="mt-2 text-center">
        //                 <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-secondary me-2">
        //                     Abrir PDF en nueva pestaña
        //                 </a>
        //                 <a href="${rutaCompleta}" download class="btn btn-sm btn-outline-primary">
        //                     Descargar PDF
        //                 </a>
        //             </div>
        //         `;
        //         }

        //         actualizarContadorMaterial();
        //     }

        //     // Función para actualizar contador de materiales
        //     function actualizarContadorMaterial() {
        //         contadorMaterial.textContent = `Material ${materialActual + 1} de ${materialesActuales.length}`;
        //     }
        // }



        function generarBloque(tema, temaIndex) {
            const bloqueDiv = document.createElement("div");
            bloqueDiv.className = `tema-container mb-5 p-4 border rounded bg-light animate__animated animate__fadeIn`;

            bloqueDiv.style.display = temaIndex === 0 ? "block" : "none"; // Solo muestra el primer tema al inicio

            bloqueDiv.innerHTML = `
        <h2 class="mb-3 text-primary"><i class="bi bi-journal-bookmark-fill"></i> ${tema.titulo}</h2>
        <div class="mb-4">
            <div class="progress" style="height: 25px;">
                <div id="progress-bar-${temaIndex}" class="progress-bar progress-bar-striped progress-bar-animated bg-success" style="width: 0%">
                    0%
                </div>
            </div>
        </div>
        <ul class="list-group list-group-flush mb-4" id="lista-temas-${temaIndex}"></ul>
        <div class="text-end">
            <button class="btn btn-success btn-lg" id="siguiente-tema-${temaIndex}">
                <i class="bi bi-arrow-right-circle-fill"></i> Siguiente Tema
            </button>
        </div>

        <div id="reproductor-container-${temaIndex}" class="mt-4 border p-3 rounded bg-white shadow-sm" style="display: none;">
            <div id="reproductor-${temaIndex}" class="mb-3"></div>
            <div id="controles-material-${temaIndex}" class="d-flex align-items-center" style="display: none;">
                <button id="siguiente-material-${temaIndex}" class="btn btn-outline-primary btn-sm">
                    <i class="bi bi-skip-forward-fill"></i> Siguiente Material
                </button>
                <span id="contador-material-${temaIndex}" class="ms-3 text-muted"></span>
            </div>
        </div>
    `;

            container.appendChild(bloqueDiv);

            const listaTemas = bloqueDiv.querySelector(`#lista-temas-${temaIndex}`);
            const progressBar = bloqueDiv.querySelector(`#progress-bar-${temaIndex}`);
            const siguienteTema = bloqueDiv.querySelector(`#siguiente-tema-${temaIndex}`);
            const reproductorContainer = bloqueDiv.querySelector(`#reproductor-container-${temaIndex}`);
            const reproductor = bloqueDiv.querySelector(`#reproductor-${temaIndex}`);
            const controlesMaterial = bloqueDiv.querySelector(`#controles-material-${temaIndex}`);
            const siguienteMaterial = bloqueDiv.querySelector(`#siguiente-material-${temaIndex}`);
            const contadorMaterial = bloqueDiv.querySelector(`#contador-material-${temaIndex}`);

            let temaActual = 0;
            let materialActual = 0;
            let materialesActuales = [];

            // Mostrar subtemas
            if (tema.contenidos && tema.contenidos.length > 0) {
                tema.contenidos.forEach((contenido, index) => {
                    const li = document.createElement("li");
                    li.className = "list-group-item d-flex justify-content-between align-items-center";
                    li.innerHTML = `
                ${contenido.nombre}
                <span class="badge bg-secondary" id="check-${temaIndex}-${index}">
                    <i class="bi bi-hourglass-split"></i>
                </span>
            `;
                    listaTemas.appendChild(li);
                });
            } else {
                listaTemas.innerHTML = '<li class="list-group-item">No hay subtemas disponibles</li>';
            }

            siguienteTema.addEventListener("click", () => {
                if (temaActual < (tema.contenidos?.length || 0)) {
                    // 1. Marcar subtema como completado
                    const check = document.getElementById(`check-${temaIndex}-${temaActual}`);
                    if (check) {
                        check.innerHTML = `<i class="bi bi-check-circle-fill"></i>`;
                        check.classList.replace("bg-secondary", "bg-success");
                    }

                    // 2. Cargar materiales del subtema actual
                    const contenidoActual = tema.contenidos[temaActual];
                    if (contenidoActual?.materiales && contenidoActual.materiales.length > 0) {
                        materialesActuales = contenidoActual.materiales
                            .filter(material => ['video', 'pdf'].includes(material.tipo.toLowerCase()))
                            .map(material => ({
                                tipo: material.tipo.toLowerCase(),
                                ruta: material.ruta
                            }));

                        materialActual = 0;
                        if (materialesActuales.length > 0) {
                            mostrarMaterial(temaIndex, materialActual);
                            reproductorContainer.style.display = "block";
                            controlesMaterial.style.display = materialesActuales.length > 1 ? "flex" : "none";
                            actualizarContadorMaterial();
                        } else {
                            reproductorContainer.style.display = "none";
                        }
                    }

                    // 3. Incrementar contador de subtema
                    temaActual++;

                    // 4. Actualizar progreso
                    calcularProgresoPorTemas();

                    // 5. Cambiar texto del botón si es el último subtema
                    if (temaActual >= tema.contenidos.length) {
                        siguienteTema.innerHTML = `<i class="bi bi-check-circle-fill"></i> Finalizar Tema`;

                        // Cambiar el comportamiento del botón para confirmar finalización
                        siguienteTema.removeEventListener("click", arguments.callee);
                        siguienteTema.addEventListener("click", () => {
                            // Solo pasar al siguiente tema cuando el usuario confirme
                            const temas = document.querySelectorAll('.tema-container');
                            temas[temaIndex].classList.add("animate__animated", "animate__fadeOut");

                            temas[temaIndex].addEventListener('animationend', () => {
                                temas[temaIndex].style.display = "none";

                                if (temas[temaIndex + 1]) {
                                    temas[temaIndex + 1].style.display = "block";
                                    temas[temaIndex + 1].classList.add("animate__animated",
                                        "animate__fadeIn");
                                } else {
                                    Swal.fire({
                                        title: "¡Curso terminado!",
                                        text: "Has completado todos los temas. Puedes realizar la evaluación.",
                                        icon: "success",
                                        confirmButtonText: "Continuar",
                                    });
                                }

                                verificarTodosTemasCompletados();
                            }, {
                                once: true
                            });
                        });
                    }
                }
            });




            function calcularProgresoPorTemas() {
                const todosTemas = document.querySelectorAll('.tema-container');
                let temasCompletos = 0;

                todosTemas.forEach((tema) => {
                    const checks = tema.querySelectorAll('.list-group-item .badge.bg-success');
                    const totalChecks = tema.querySelectorAll('.list-group-item .badge').length;

                    if (checks.length === totalChecks && totalChecks > 0) {
                        temasCompletos++;
                    }
                });

                const progresoGeneral = Math.floor((temasCompletos / todosTemas.length) * 100);

                // Actualizar progreso en cada progress bar
                todosTemas.forEach((tema, index) => {
                    const pb = tema.querySelector(`#progress-bar-${index}`);
                    if (pb) {
                        pb.style.width = `${progresoGeneral}%`;
                        pb.innerText = `${progresoGeneral}%`;
                    }
                });

                fetch('../../../../controllers/actualizar-progreso-curso.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `curso_id=${cursoID}&progreso=${progresoGeneral}`
                }).catch(error => console.error('Error al actualizar progreso:', error));
            }

            siguienteMaterial.addEventListener("click", () => {
                materialActual++;
                if (materialActual < materialesActuales.length) {
                    mostrarMaterial(temaIndex, materialActual);
                    actualizarContadorMaterial();
                } else {
                    reproductorContainer.style.display = "none";
                }
            });

            function mostrarMaterial(temaIndex, materialIndex) {
                const material = materialesActuales[materialIndex];
                reproductor.innerHTML = '';


                let rutaMaterial = String(material.ruta).trim();

                rutaMaterial = rutaMaterial
                    .replace(/([^:]\/)\/+/g, '$1')
                    .replace(/^\/+/, '')
                    .replace(/\/+$/, '');
                const rutaCompleta = rutaMaterial.startsWith('http') || rutaMaterial.startsWith('/') ?
                    rutaMaterial :
                    `../../../../controllers/${rutaMaterial}`;

                // Mostrar loader
                reproductor.innerHTML = `
            <div class="d-flex flex-column justify-content-center align-items-center py-5">
                <div class="spinner-border text-primary mb-3" style="width: 3rem; height: 3rem;" role="status">
                    <span class="visually-hidden">Cargando...</span>
                </div>
                <h5 class="text-primary">Cargando ${material.tipo === 'video' ? 'video' : 'documento'}...</h5>
            </div>
        `;

                // Mostrar contenido después de breve delay (simulando carga)
                setTimeout(() => {
                    if (material.tipo === 'video') {

                        reproductor.innerHTML = `
                    <div class="mb-3">
                        <h5 class="d-flex align-items-center">
                            <i class="fas fa-film me-2 text-primary"></i>
                            ${material.nombre}
                        </h5>
                        <small class="text-muted">Video formativo</small>
                    </div>
                    <div class="ratio ratio-16x9 bg-dark rounded-3 overflow-hidden shadow">
                        <video controls class="w-100" style="background-color: #000;">
                            <source src="${rutaCompleta}" type="video/mp4">
                            Tu navegador no soporta el elemento de video.
                        </video>
                    </div>
                    <div class="mt-3 text-end">
                        <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-external-link-alt me-1"></i>Abrir en nueva pestaña
                        </a>
                    </div>
                `;
                    } else { // PDF
                        reproductor.innerHTML = `
                    <div class="mb-3">
                        <h5 class="d-flex align-items-center">
                            <i class="fas fa-file-pdf me-2 text-danger"></i>
                            ${material.nombre}
                        </h5>
                        <small class="text-muted">Documento PDF</small>
                    </div>
                    <div class="ratio ratio-16x9 bg-light rounded-3 overflow-hidden shadow">
                        <iframe src="${rutaCompleta}#view=fitH&toolbar=0&navpanes=0" 
                                class="w-100 border-0" 
                                style="background-color: #fff;">
                        </iframe>
                    </div>
                    <div class="mt-3 d-flex justify-content-between">
                        <a href="${rutaCompleta}" download class="btn btn-sm btn-outline-secondary">
                            <i class="fas fa-download me-1"></i>Descargar
                        </a>
                        <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-primary">
                            <i class="fas fa-external-link-alt me-1"></i>Abrir completo
                        </a>
                    </div>
                `;
                    }

                    // Animación de aparición
                    reproductor.classList.add("animate__animated", "animate__fadeIn");
                }, 800);
            }

            function actualizarContadorMaterial() {
                contadorMaterial.textContent = `Material ${materialActual + 1} de ${materialesActuales.length}`;
            }
        }



        // function generarBloque(tema, temaIndex) {
        //     const bloqueDiv = document.createElement("div");
        //     bloqueDiv.className = `tema-container mb-5 p-4 border rounded-3 shadow-sm ${temaIndex > 0 ? 'd-none' : ''}`;

        //     bloqueDiv.style.transition = "all 0.5s ease";

        //     bloqueDiv.innerHTML = `
        //     <h2 class="mb-3 text-primary">
        //         <i class="fas fa-book-open me-2"></i>${tema.titulo}
        //     </h2>
        //     <div class="mb-4">
        //         <div class="progress" style="height: 10px;">
        //             <div id="progress-bar-${temaIndex}" 
        //                  class="progress-bar progress-bar-striped bg-success" 
        //                  role="progressbar" 
        //                  style="width: 0%">
        //             </div>
        //         </div>
        //         <small id="progress-text-${temaIndex}" class="text-muted mt-1 d-block">0% completado</small>
        //     </div>
        //     <ul class="list-group mb-4" id="lista-temas-${temaIndex}"></ul>
        //     <div class="text-end mt-3">
        //         <button class="btn btn-primary px-4 py-2" id="siguiente-tema-${temaIndex}">
        //             <i class="fas fa-arrow-right me-2"></i>Comenzar Tema
        //         </button>
        //     </div>
        //     <div id="reproductor-container-${temaIndex}" class="mt-4 border p-3 rounded-3 bg-light" style="display: none; transition: all 0.3s ease;">
        //         <div id="reproductor-${temaIndex}" class="mb-3"></div>
        //         <div id="controles-material-${temaIndex}" class="d-flex justify-content-between align-items-center mt-3" style="display: none;">
        //             <button id="anterior-material-${temaIndex}" class="btn btn-outline-secondary px-3">
        //                 <i class="fas fa-arrow-left me-1"></i>Anterior
        //             </button>
        //             <span id="contador-material-${temaIndex}" class="badge bg-primary px-3 py-2"></span>
        //             <button id="siguiente-material-${temaIndex}" class="btn btn-outline-primary px-3">
        //                 Siguiente<i class="fas fa-arrow-right ms-1"></i>
        //             </button>
        //         </div>
        //     </div>
        // `;

        //     container.appendChild(bloqueDiv);

        //     // Elementos del DOM
        //     const listaTemas = bloqueDiv.querySelector(`#lista-temas-${temaIndex}`);
        //     const progressBar = bloqueDiv.querySelector(`#progress-bar-${temaIndex}`);
        //     const progressText = bloqueDiv.querySelector(`#progress-text-${temaIndex}`);
        //     const siguienteTema = bloqueDiv.querySelector(`#siguiente-tema-${temaIndex}`);
        //     const reproductorContainer = bloqueDiv.querySelector(`#reproductor-container-${temaIndex}`);
        //     const reproductor = bloqueDiv.querySelector(`#reproductor-${temaIndex}`);
        //     const controlesMaterial = bloqueDiv.querySelector(`#controles-material-${temaIndex}`);
        //     const siguienteMaterial = bloqueDiv.querySelector(`#siguiente-material-${temaIndex}`);
        //     const anteriorMaterial = bloqueDiv.querySelector(`#anterior-material-${temaIndex}`);
        //     const contadorMaterial = bloqueDiv.querySelector(`#contador-material-${temaIndex}`);

        //     // Variables de estado
        //     let temaActual = 0;
        //     let materialActual = 0;
        //     let materialesActuales = [];

        //     // Mostrar subtemas
        //     if (tema.contenidos && tema.contenidos.length > 0) {
        //         tema.contenidos.forEach((contenido, index) => {
        //             const li = document.createElement("li");
        //             li.className = "list-group-item d-flex justify-content-between align-items-center py-3";
        //             li.innerHTML = `
        //             <div class="d-flex align-items-center">
        //                 <span class="badge bg-secondary me-3">${index + 1}</span>
        //                 <span>${contenido.nombre}</span>
        //             </div>
        //             <span class="badge bg-light text-dark border" id="check-${temaIndex}-${index}">
        //                 <i class="fas fa-clock me-1"></i>Pendiente
        //             </span>
        //         `;
        //             listaTemas.appendChild(li);
        //         });
        //     } else {
        //         listaTemas.innerHTML = `
        //         <li class="list-group-item text-center py-4 text-muted">
        //             <i class="fas fa-info-circle me-2"></i>No hay subtemas disponibles
        //         </li>
        //     `;
        //     }

        //     // Evento para siguiente tema
        //     siguienteTema.addEventListener("click", () => {
        //         if (temaActual < (tema.contenidos?.length || 0)) {
        //             // Marcar subtema como completado
        //             const check = document.getElementById(`check-${temaIndex}-${temaActual}`);
        //             if (check) {
        //                 check.innerHTML = `
        //                 <i class="fas fa-check-circle me-1"></i>Completado
        //             `;
        //                 check.className = "badge bg-success text-white";
        //                 check.classList.add("animate__animated", "animate__pulse");
        //             }

        //             // Cargar materiales
        //             const contenidoActual = tema.contenidos[temaActual];
        //             if (contenidoActual?.materiales) {
        //                 materialesActuales = contenidoActual.materiales
        //                     .filter(m => ['video', 'pdf'].includes(m.tipo.toLowerCase()))
        //                     .map(m => ({
        //                         tipo: m.tipo.toLowerCase(),
        //                         ruta: m.ruta,
        //                         nombre: m.nombre || `Material ${temaActual + 1}`
        //                     }));

        //                 if (materialesActuales.length > 0) {
        //                     materialActual = 0;
        //                     mostrarMaterial(temaIndex, materialActual);
        //                     reproductorContainer.style.display = "block";
        //                     controlesMaterial.style.display = "flex";
        //                     actualizarContadorMaterial();

        //                     // Animación de aparición
        //                     reproductorContainer.classList.add("animate__animated", "animate__fadeIn");

        //                     // Desplazamiento suave al reproductor
        //                     setTimeout(() => {
        //                         reproductorContainer.scrollIntoView({
        //                             behavior: 'smooth',
        //                             block: 'nearest'
        //                         });
        //                     }, 300);
        //                 }
        //             }

        //             temaActual++;
        //             actualizarProgreso();

        //             // Cambiar texto del botón si es el último subtema
        //             if (temaActual >= tema.contenidos.length) {
        //                 siguienteTema.innerHTML = `
        //                 <i class="fas fa-check-double me-2"></i>Completar Tema
        //             `;
        //             }
        //         }
        //     });

        //     // Función para mostrar materiales (MANTENIENDO LA FUNCIONALIDAD ORIGINAL)
        //     function mostrarMaterial(temaIndex, materialIndex) {
        //         const material = materialesActuales[materialIndex];
        //         reproductor.innerHTML = '';


        //         let rutaMaterial = String(material.ruta).trim();

        //         rutaMaterial = rutaMaterial
        //             .replace(/([^:]\/)\/+/g, '$1')
        //             .replace(/^\/+/, '')
        //             .replace(/\/+$/, '');
        //         const rutaCompleta = rutaMaterial.startsWith('http') || rutaMaterial.startsWith('/') ?
        //             rutaMaterial :
        //             `../../../../controllers/${rutaMaterial}`;

        //         // Mostrar loader
        //         reproductor.innerHTML = `
        //         <div class="d-flex flex-column justify-content-center align-items-center py-5">
        //             <div class="spinner-border text-primary mb-3" style="width: 3rem; height: 3rem;" role="status">
        //                 <span class="visually-hidden">Cargando...</span>
        //             </div>
        //             <h5 class="text-primary">Cargando ${material.tipo === 'video' ? 'video' : 'documento'}...</h5>
        //         </div>
        //     `;

        //         // Mostrar contenido después de breve delay (simulando carga)
        //         setTimeout(() => {
        //             if (material.tipo === 'video') {

        //                 reproductor.innerHTML = `
        //                 <div class="mb-3">
        //                     <h5 class="d-flex align-items-center">
        //                         <i class="fas fa-film me-2 text-primary"></i>
        //                         ${material.nombre}
        //                     </h5>
        //                     <small class="text-muted">Video formativo</small>
        //                 </div>
        //                 <div class="ratio ratio-16x9 bg-dark rounded-3 overflow-hidden shadow">
        //                     <video controls class="w-100" style="background-color: #000;">
        //                         <source src="${rutaCompleta}" type="video/mp4">
        //                         Tu navegador no soporta el elemento de video.
        //                     </video>
        //                 </div>
        //                 <div class="mt-3 text-end">
        //                     <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-primary">
        //                         <i class="fas fa-external-link-alt me-1"></i>Abrir en nueva pestaña
        //                     </a>
        //                 </div>
        //             `;
        //             } else { // PDF
        //                 reproductor.innerHTML = `
        //                 <div class="mb-3">
        //                     <h5 class="d-flex align-items-center">
        //                         <i class="fas fa-file-pdf me-2 text-danger"></i>
        //                         ${material.nombre}
        //                     </h5>
        //                     <small class="text-muted">Documento PDF</small>
        //                 </div>
        //                 <div class="ratio ratio-16x9 bg-light rounded-3 overflow-hidden shadow">
        //                     <iframe src="${rutaCompleta}#view=fitH&toolbar=0&navpanes=0" 
        //                             class="w-100 border-0" 
        //                             style="background-color: #fff;">
        //                     </iframe>
        //                 </div>
        //                 <div class="mt-3 d-flex justify-content-between">
        //                     <a href="${rutaCompleta}" download class="btn btn-sm btn-outline-secondary">
        //                         <i class="fas fa-download me-1"></i>Descargar
        //                     </a>
        //                     <a href="${rutaCompleta}" target="_blank" class="btn btn-sm btn-outline-primary">
        //                         <i class="fas fa-external-link-alt me-1"></i>Abrir completo
        //                     </a>
        //                 </div>
        //             `;
        //             }

        //             // Animación de aparición
        //             reproductor.classList.add("animate__animated", "animate__fadeIn");
        //         }, 800);
        //     }

        //     // Funciones auxiliares (se mantienen igual)
        //     function actualizarContadorMaterial() {
        //         contadorMaterial.textContent = `${materialActual + 1} / ${materialesActuales.length}`;
        //         anteriorMaterial.style.display = materialActual > 0 ? "block" : "none";
        //         siguienteMaterial.style.display = materialActual < materialesActuales.length - 1 ? "block" : "none";
        //     }

        //     function actualizarProgreso() {
        //         const progreso = (temaActual / tema.contenidos.length) * 100;
        //         progressBar.style.width = `${progreso}%`;
        //         progressText.textContent = `${Math.round(progreso)}% completado`;

        //         if (progreso === 100) {
        //             progressBar.classList.add("animate__animated", "animate__pulse");
        //         }
        //     }
        // }

        // Función para verificar si todos los temas están completos
        function verificarTodosTemasCompletados() {
            const todosTemas = document.querySelectorAll('.tema-container');
            let temasCompletos = 0;

            todosTemas.forEach((tema) => {
                const checks = tema.querySelectorAll('.list-group-item .badge.bg-success');
                const totalChecks = tema.querySelectorAll('.list-group-item .badge').length;

                if (checks.length === totalChecks && totalChecks > 0) {
                    temasCompletos++;
                }
            });

            if (temasCompletos === todosTemas.length && !cuestionarioMostrado && preguntasGlobales.length > 0) {
                mostrarCuestionarioFinal();
                cuestionarioMostrado = true;
            }
        }

        // Función para mostrar el cuestionario final
        function mostrarCuestionarioFinal() {
            const cuestionarioDiv = document.createElement("div");
            cuestionarioDiv.className = "mt-5 p-4 border rounded bg-light";
            cuestionarioDiv.innerHTML = `
        <h2 class="mb-4">Cuestionario Final</h2>
        <form id="form-cuestionario-final">
            <div id="preguntas-final-container"></div>
            <button type="submit" class="btn btn-success mt-3">Enviar Cuestionario</button>
        </form>
    `;
            container.appendChild(cuestionarioDiv);

            const preguntasContainer = document.getElementById("preguntas-final-container");

            preguntasGlobales.forEach((pregunta, index) => {
                const preguntaDiv = document.createElement("div");
                preguntaDiv.className = "mb-4 p-3 border rounded bg-white";

                let opcionesHTML = "";
                if (pregunta.opciones && pregunta.opciones.length > 0) {
                    pregunta.opciones.forEach((opcion, opcionIndex) => {
                        opcionesHTML += `
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="radio" 
                               name="pregunta-final-${index}" 
                               id="pregunta-final-${index}-${opcionIndex}"
                               value="${opcion.id}" required>
                        <label class="form-check-label" for="pregunta-final-${index}-${opcionIndex}">
                            ${opcion.texto}
                        </label>
                    </div>
                `;
                    });
                }

                preguntaDiv.innerHTML = `
            <h5 class="mb-3">${index + 1}. ${pregunta.texto}</h5>
            ${opcionesHTML}
        `;
                preguntasContainer.appendChild(preguntaDiv);
            });

            // Manejar envío del cuestionario final
            document.getElementById("form-cuestionario-final").addEventListener("submit", (e) => {
                e.preventDefault();
                calificarCuestionarioFinal();
            });
        }


        // Función para calificar el cuestionario final y manejar certificados
        async function calificarCuestionarioFinal() {
            try {
                // Calcular respuestas correctas
                let respuestasCorrectas = 0;

                preguntasGlobales.forEach((pregunta, index) => {
                    const selectedOption = document.querySelector(
                        `input[name="pregunta-final-${index}"]:checked`);

                    if (selectedOption) {
                        const opcionId = selectedOption.value;
                        const opcion = pregunta.opciones.find(op => op.id == opcionId);
                        if (opcion && opcion.correcta) {
                            respuestasCorrectas++;
                        }
                    }
                });

                // Calcular puntuación
                const calificacion = (respuestasCorrectas / preguntasGlobales.length) * 10;
                const calificacionRedondeada = calificacion.toFixed(1);

                // Mostrar resultado con SweetAlert
                const result = await Swal.fire({
                    title: 'Resultado del Cuestionario',
                    html: `Tu calificación: <strong>${calificacionRedondeada}/10</strong>`,
                    icon: calificacion > 5 ? 'success' : 'info',
                    showCancelButton: calificacion > 5,
                    confirmButtonText: calificacion > 5 ? 'Descargar Certificado' : 'Aceptar',
                    cancelButtonText: 'Volver al Curso',
                    showDenyButton: calificacion < 5,
                    denyButtonText: 'Reintentar Cuestionario'
                });

                // Manejar acciones según la calificación
                if (calificacion >= 5) {
                    if (result.isConfirmed) {
                        // Descargar certificado
                        descargarCertificado(calificacionRedondeada);
                    } else if (result.isDismissed) {
                        // Redirigir al curso
                        window.location.href = `curso.php?cursoseleccionado=${cursoID}`;
                    }
                } else {
                    if (result.isDenied) {
                        // Reintentar cuestionario
                        reiniciarCuestionario();
                    } else {
                        // Redirigir al curso
                        window.location.href = `curso.php?cursoseleccionado=${cursoID}`;
                    }
                }

            } catch (error) {
                console.error('Error al calificar:', error);
                Swal.fire('Error', 'Ocurrió un error al procesar tu calificación', 'error');
            }
        }

        // Función para descargar el certificado
        async function descargarCertificado(calificacion) {
            try {
                // Mostrar loader
                Swal.fire({
                    title: 'Generando certificado',
                    html: 'Por favor espere...',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                // Llamar al backend para generar PDF
                const response = await fetch(
                    `../../../../controllers/generar_certificado.php?calificacion=${calificacion}&curso_id=${cursoID}`, {
                        method: 'GET'
                    });

                if (!response.ok) {
                    const errorData = await response.json();
                    throw new Error(`Error al generar certificado: ${response.status} - ${errorData.error}`);
                }

                // Obtener el blob del PDF y el nombre del archivo de la cabecera
                const contentDisposition = response.headers.get('Content-Disposition');
                let filename = `certificado_${new Date().toISOString().split('T')[0]}.pdf`; // Nombre por defecto
                if (contentDisposition && contentDisposition.indexOf('attachment') !== -1) {
                    const filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                    const matches = filenameRegex.exec(contentDisposition);
                    if (matches != null && matches[1]) {
                        filename = matches[1].replace(/['"]/g, '');
                    }
                }
                const blob = await response.blob();
                const url = window.URL.createObjectURL(blob);

                // Crear enlace para descarga
                const a = document.createElement('a');
                a.href = url;
                a.download = filename; // Usar el nombre de archivo obtenido
                document.body.appendChild(a);
                a.click();

                // Limpiar
                window.URL.revokeObjectURL(url);
                a.remove();

                Swal.close();
                // ✅ Esperar un momento y redirigir al curso
                setTimeout(() => {
                    window.location.href = `curso.php?cursoseleccionado=${cursoID}`;
                }, 1000); // Espera 2 segundos (ajustable)

            } catch (error) {
                console.error('Error al descargar certificado:', error);
                Swal.fire('Error', `No se pudo generar el certificado: ${error.message}`, 'error');
            }
        }

        // Función para reiniciar el cuestionario
        function reiniciarCuestionario() {
            // Limpiar selecciones
            preguntasGlobales.forEach((_, index) => {
                const selectedOption = document.querySelector(
                    `input[name="pregunta-final-${index}"]:checked`);
                if (selectedOption) {
                    selectedOption.checked = false;
                }
            });

            // Scroll al inicio
            window.scrollTo(0, 0);
        }

        // Obtener datos del curso
        fetch(`../../../../controllers/obtencionCuestionariosController.php?curso_id=${cursoID}`)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Error en la solicitud: ' + response.status);
                }
                return response.json();
            })
            .then(data => {
                console.log("Datos recibidos:", data);

                if (data && data.temario) {
                    // Guardar preguntas globalmente
                    preguntasGlobales = data.preguntas || [];

                    // Mostrar título del curso
                    if (data.curso_title) {
                        const tituloCurso = document.createElement("h1");
                        tituloCurso.className = "mb-4";
                        tituloCurso.textContent = data.curso_title;
                        container.prepend(tituloCurso);
                    }

                    // Mostrar cada tema del temario
                    data.temario.forEach((tema, index) => {
                        try {
                            generarBloque(tema, index);
                        } catch (e) {
                            console.error("Error generando bloque:", e);
                        }
                    });
                } else {
                    container.innerHTML =
                        '<div class="alert alert-info">No se encontraron datos para este curso.</div>';
                }
            })
            .catch(error => {
                console.error('Error al obtener los datos:', error);
                container.innerHTML = '<div class="alert alert-danger">Error al cargar el contenido del curso.</div>';
            });
    </script>


</body>

</html>