<?php $cursoID = isset($_GET['cursodetalle']) ? (int) $_GET['cursodetalle'] : null;
?>
<?php require('./src/component/navbar.php'); ?>
<section class="breadcrumb-wrapper fix bg-cover py-5">
    <div class="container">
        <div class="row justify-content-center align-items-center text-center">
            <div class="col">
                <div class="page-heading">
                    <h2 class="wow fadeInUp" data-wow-delay=".3s"
                        style="visibility: visible; animation-delay: 0.3s; animation-name: fadeInUp;">Detalles Curso
                    </h2>
                    <ul class="breadcrumb-list wow fadeInUp list-inline" data-wow-delay=".5s"
                        style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
                        <li class="list-inline-item">
                            <a href="index.php">Home</a>
                        </li>
                        <li class="list-inline-item"><i class="fa-solid fa-chevron-right"></i></li>
                        <li class="list-inline-item">Detalles Curso <?= $cursoID; ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="courses-details-section section-padding">
    <div class="container">
        <div class="courses-details-wrapper">
            <div class="row g-4">
                <?php
                $stmt = mysqli_prepare($conexion, "SELECT c.curso_id, c.curso_title, c.curso_description, c.fecha_inicio, c.fecha_fin, c.created_at, c.categoria_id, cat.titulo, cat.url_img, dc.objetivos_aprendizaje, dc.audiencia_objetivo, dc.requisitos_previos, dc.duracion, dc.modalidad,  dc.evaluacion, dc.instructor FROM cursos c LEFT JOIN detalles_curso dc ON dc.curso_id = c.curso_id LEFT JOIN categoria cat ON cat.categoria_id = c.categoria_id WHERE c.curso_id = ?");
                mysqli_stmt_bind_param($stmt, "i", $cursoID);
                mysqli_stmt_execute($stmt);
                $result = mysqli_stmt_get_result($stmt);
                
                
                $row2 = mysqli_fetch_assoc($result);
if (!$row2) {
    echo "No se obtuvo ninguna fila del resultado.<br>";
}

                if ($row2) {
                ?>
                <div class="col-lg-8 col-12">
                    <div class="courses-content">
                        <div class="star">
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star"></i>
                            <i class="fa-solid fa-star color"></i>
                        </div>
                        <h2>
                            <?= $row2["curso_title"] ?>
                        </h2>
                        <div class="details-image">
                            <img src="https://www.uhipocrates.edu.mx/wp-content/uploads/2022/08/Beneficios-de-tomar-cursos-en-linea-2-1200x900.jpg"
                                alt="img">
                        </div>
                        <div class="courses-details-content">
                            <ul class="nav" role="tablist">
                                <li class="nav-item wow fadeInUp" data-wow-delay=".3s" role="presentation"
                                    style="visibility: visible; animation-delay: 0.3s; animation-name: fadeInUp;">
                                    <a href="#Course" data-bs-toggle="tab" class="nav-link active" aria-selected="true"
                                        role="tab">
                                        Informació del Curso
                                    </a>
                                </li>
                                <li class="nav-item wow fadeInUp" data-wow-delay=".5s" role="presentation"
                                    style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
                                    <a href="#Curriculum" data-bs-toggle="tab" class="nav-link" aria-selected="false"
                                        tabindex="-1" role="tab">
                                        Temario <?= $cursoID; ?>
                                    </a>
                                </li>
                                <li class="nav-item wow fadeInUp" data-wow-delay=".5s" role="presentation"
                                    style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
                                    <a href="#Instructors" data-bs-toggle="tab" class="nav-link" aria-selected="false"
                                        tabindex="-1" role="tab">
                                        Intructor
                                    </a>
                                </li>
                                <li class="nav-item wow fadeInUp" data-wow-delay=".5s" role="presentation"
                                    style="visibility: visible; animation-delay: 0.5s; animation-name: fadeInUp;">
                                    <a href="#Reviews" data-bs-toggle="tab" class="nav-link bb-none"
                                        aria-selected="false" tabindex="-1" role="tab">
                                        Reviews
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div id="Course" class="tab-pane fade show active" role="tabpanel">
                                    <div class="description-content">
                                        <h3>Description</h3>
                                        <p class="mb-3">
                                            <?= htmlspecialchars($row2["curso_description"]) ?>
                                        </p>


                                        <h3>Objetivos de Aprendizaje</h3>
                                        <p>
                                            <?= htmlspecialchars($row2["objetivos_aprendizaje"]) ?>
                                        </p>
                                    </div>
                                </div>




                                <div id="Curriculum" class="tab-pane fade" role="tabpanel">
                                    <div class="course-curriculum-items">

                                        <div class="courses-faq-items">
                                            <div class="temario-curso">
                                                <h3 class="mb-4 text-primary">
                                                    <i class="fas fa-book-open me-2"></i> Temario del Curso
                                                </h3>

                                                <div class="accordion" id="temarioAccordion">
                                                    <?php
                                                        // Consulta SQL mejorada
                                                        $stmt = mysqli_prepare($conexion, "
            SELECT 
                c.curso_id,
                tt.ID_Titulo,
                tt.nom_titulo_temario,
                cot.id_Contenido,
                cot.nombre_contenido,
                cot.descripcion_contenido,
                GROUP_CONCAT(mt.tipo_material SEPARATOR '|') AS tipos_materiales,
                GROUP_CONCAT(mt.ruta_archivo SEPARATOR '|') AS rutas_materiales
            FROM cursos c
            LEFT JOIN titulos_temarios tt ON tt.curso_id = c.curso_id
            LEFT JOIN contenidos_titulos_temarios cot ON cot.ID_Titulo = tt.ID_Titulo
            LEFT JOIN materiales_contenido mt ON mt.id_Contenido = cot.id_Contenido
            WHERE c.curso_id = ?
            GROUP BY tt.ID_Titulo, tt.nom_titulo_temario, cot.id_Contenido, cot.nombre_contenido, cot.descripcion_contenido
            ORDER BY tt.Orden, cot.Orden
        ");

                                                        mysqli_stmt_bind_param($stmt, "i", $cursoID);
                                                        mysqli_stmt_execute($stmt);
                                                        $result = mysqli_stmt_get_result($stmt);

                                                        $temario_organizado = [];

                                                        while ($row = mysqli_fetch_assoc($result)) {
                                                            $titulo = $row['nom_titulo_temario'];
                                                            if (!isset($temario_organizado[$titulo])) {
                                                                $temario_organizado[$titulo] = [];
                                                            }

                                                            $temario_organizado[$titulo][] = [
                                                                'nombre' => $row['nombre_contenido'],
                                                                'descripcion' => $row['descripcion_contenido'],
                                                                'tipos_materiales' => !empty($row['tipos_materiales']) ? explode('|', $row['tipos_materiales']) : [],
                                                                'rutas_materiales' => !empty($row['rutas_materiales']) ? explode('|', $row['rutas_materiales']) : []
                                                            ];
                                                        }

                                                        mysqli_stmt_close($stmt);

                                                        $index = 0;
                                                        foreach ($temario_organizado as $titulo => $contenidos) {
                                                        ?>
                                                    <div class="accordion-item border-0 mb-2 shadow-sm">
                                                        <h2 class="accordion-header" id="heading_<?= $index ?>">
                                                            <button
                                                                class="accordion-button collapsed bg-light-primary text-primary fw-bold"
                                                                type="button" data-bs-toggle="collapse"
                                                                data-bs-target="#collapse_<?= $index ?>"
                                                                aria-expanded="false"
                                                                aria-controls="collapse_<?= $index ?>">
                                                                <i class="fas fa-folder-open me-2"></i>
                                                                <?= htmlspecialchars($titulo) ?>
                                                                <span
                                                                    class="badge bg-primary rounded-pill ms-2"><?= count($contenidos) ?></span>
                                                            </button>
                                                        </h2>

                                                        <div id="collapse_<?= $index ?>"
                                                            class="accordion-collapse collapse"
                                                            aria-labelledby="heading_<?= $index ?>"
                                                            data-bs-parent="#temarioAccordion">
                                                            <div class="accordion-body pt-3">
                                                                <div class="list-group">
                                                                    <?php foreach ($contenidos as $contenido): ?>
                                                                    <div
                                                                        class="list-group-item border-0 mb-2 rounded shadow-sm">
                                                                        <div
                                                                            class="d-flex justify-content-between align-items-start">
                                                                            <div class="me-3">
                                                                                <h5 class="mb-1 fw-semibold">
                                                                                    <?= htmlspecialchars($contenido['nombre']) ?>
                                                                                </h5>
                                                                                <?php if (!empty($contenido['descripcion'])): ?>
                                                                                <p class="mb-2 text-muted small">
                                                                                    <?= htmlspecialchars($contenido['descripcion']) ?>
                                                                                </p>
                                                                                <?php endif; ?>
                                                                            </div>

                                                                            <div
                                                                                class="badge bg-light text-primary rounded-pill">
                                                                                <?= count($contenido['tipos_materiales']) ?>
                                                                                recursos
                                                                            </div>
                                                                        </div>

                                                                        <?php if (!empty($contenido['tipos_materiales'])): ?>
                                                                        <div class="mt-2">
                                                                            <div class="d-flex flex-wrap gap-2">
                                                                                <?php foreach ($contenido['tipos_materiales'] as $i => $tipo): ?>
                                                                                <?php
                                                                                                    $icon_class = match ($tipo) {
                                                                                                        'Video' => 'fa-solid fa-play text-danger',
                                                                                                        'PDF' => 'fa-solid fa-file-pdf text-danger',
                                                                                                        'Word' => 'fa-solid fa-file-word text-primary',
                                                                                                        'Imagen' => 'fa-solid fa-image text-success',
                                                                                                        default => 'fa-solid fa-file text-secondary',
                                                                                                    };
                                                                                                    ?>
                                                                                <a href="<?= htmlspecialchars($contenido['rutas_materiales'][$i] ?? '#') ?>"
                                                                                    class="btn btn-sm btn-outline-primary rounded-pill"
                                                                                    target="_blank">
                                                                                    <i
                                                                                        class="<?= $icon_class ?> me-1"></i>
                                                                                    <?= htmlspecialchars($tipo) ?>
                                                                                </a>
                                                                                <?php endforeach; ?>
                                                                            </div>
                                                                        </div>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <?php endforeach; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php
                                                            $index++;
                                                        }

                                                        if (empty($temario_organizado)):
                                                        ?>
                                                    <div class="alert alert-info">
                                                        <i class="fas fa-info-circle me-2"></i> Este curso aún no tiene
                                                        temario disponible.
                                                    </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>






                                <div id="Instructors" class="tab-pane fade" role="tabpanel">
                                    <div class="instructors-items">
                                        <h3>Instructors</h3>
                                        <div class="instructors-box-items">
                                            <div class="thumb">
                                                <img src="assets/img/courses/instructors-1.png" alt="img">
                                            </div>
                                            <div class="content">
                                                <h4>Ronald Richards</h4>
                                                <span>Lead UX/UI Designer</span>
                                                <p>
                                                    UX/UI design courses offer a comprehensive introduction
                                                    to the world
                                                    of user experience and user interface design
                                                </p>
                                                <div class="social-icon">
                                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                                    <a href="#" class="bg-2"><i class="fab fa-twitter"></i></a>
                                                    <a href="#"><i class="fab fa-linkedin-in"></i></a>
                                                    <a href="#"><i class="fa-brands fa-vimeo-v"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="instructors-box-items style-2">
                                            <div class="thumb">
                                                <img src="assets/img/courses/instructors-2.png" alt="img">
                                            </div>
                                            <div class="content">
                                                <h4>Leslie Alexander</h4>
                                                <span>Product Designer</span>
                                                <p>
                                                    UX/UI design courses offer a comprehensive introduction
                                                    to the world
                                                    of user experience and user interface design
                                                </p>
                                                <div class="social-icon">
                                                    <a href="#"><i class="fab fa-facebook-f"></i></a>
                                                    <a href="#" class="bg-2"><i class="fab fa-twitter"></i></a>
                                                    <a href="#"><i class="fab fa-linkedin-in"></i></a>
                                                    <a href="#"><i class="fa-brands fa-vimeo-v"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="Reviews" class="tab-pane fade" role="tabpanel">
                                    <div class="courses-reviews-items">
                                        <h3>Course Reviews</h3>
                                        <div class="courses-reviews-box-items">
                                            <div class="courses-reviews-box">
                                                <div class="reviews-box">
                                                    <h2><span class="count">4.8</span></h2>
                                                    <div class="star">
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                    </div>
                                                    <p>856+ Reviews</p>
                                                </div>
                                                <div class="reviews-ratting-right">
                                                    <div class="reviews-ratting-item">
                                                        <div class="star">
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                        </div>
                                                        <div class="progress">
                                                            <div class="progress-value style-two"></div>
                                                        </div>
                                                        <span>(10)</span>
                                                    </div>
                                                    <div class="reviews-ratting-item">
                                                        <div class="star">
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                        </div>
                                                        <div class="progress">
                                                            <div class="progress-value style-three"></div>
                                                        </div>
                                                        <span>(08)</span>
                                                    </div>
                                                    <div class="reviews-ratting-item">
                                                        <div class="star">
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                        </div>
                                                        <div class="progress">
                                                            <div class="progress-value style-three"></div>
                                                        </div>
                                                        <span>(08)</span>
                                                    </div>
                                                    <div class="reviews-ratting-item">
                                                        <div class="star">
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                        </div>
                                                        <div class="progress">
                                                            <div class="progress-value style-four"></div>
                                                        </div>
                                                        <span>(01)</span>
                                                    </div>
                                                    <div class="reviews-ratting-item">
                                                        <div class="star">
                                                            <i class="fas fa-star"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                            <i class="fas fa-star color-2"></i>
                                                        </div>
                                                        <div class="progress">
                                                            <div class="progress-value style-five"></div>
                                                        </div>
                                                        <span>(00)</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="instructors-box-items">
                                                <div class="thumb">
                                                    <img src="assets/img/courses/instructors-3.png" alt="img">
                                                </div>
                                                <div class="content">
                                                    <h4>Marvin McKinney</h4>
                                                    <span>Junior UX Designer</span>
                                                    <div class="star">
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                        <i class="fas fa-star"></i>
                                                    </div>
                                                    <p>
                                                        "I enrolled in this UX/UI design course with minimal
                                                        knowledge
                                                        the field, and it completely transformed my
                                                        understanding."
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            <?php

                }

        ?>
        </div>
    </div>
</section>


<?php require('./src/component/footer.php'); ?>